/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class BasicResponseProducer
implements AsyncResponseProducer {
    private final HttpResponse response;
    private final AsyncEntityProducer dataProducer;

    public BasicResponseProducer(HttpResponse httpResponse, AsyncEntityProducer asyncEntityProducer) {
        this.response = Args.notNull(httpResponse, "Response");
        this.dataProducer = asyncEntityProducer;
    }

    public BasicResponseProducer(HttpResponse httpResponse) {
        this.response = Args.notNull(httpResponse, "Response");
        this.dataProducer = null;
    }

    public BasicResponseProducer(int n2, AsyncEntityProducer asyncEntityProducer) {
        this((HttpResponse)new BasicHttpResponse(n2), asyncEntityProducer);
    }

    public BasicResponseProducer(HttpResponse httpResponse, String string, ContentType contentType) {
        this(httpResponse, AsyncEntityProducers.create(string, contentType));
    }

    public BasicResponseProducer(HttpResponse httpResponse, String string) {
        this(httpResponse, string, ContentType.TEXT_PLAIN);
    }

    public BasicResponseProducer(int n2, String string, ContentType contentType) {
        this(new BasicHttpResponse(n2), string, contentType);
    }

    public BasicResponseProducer(int n2, String string) {
        this((HttpResponse)new BasicHttpResponse(n2), string);
    }

    public BasicResponseProducer(AsyncEntityProducer asyncEntityProducer) {
        this(200, asyncEntityProducer);
    }

    @Override
    public void sendResponse(ResponseChannel responseChannel, HttpContext httpContext) throws HttpException, IOException {
        responseChannel.sendResponse(this.response, this.dataProducer, httpContext);
    }

    @Override
    public int available() {
        if (this.dataProducer != null) {
            return this.dataProducer.available();
        }
        return 0;
    }

    @Override
    public void produce(DataStreamChannel dataStreamChannel) throws IOException {
        if (this.dataProducer != null) {
            this.dataProducer.produce(dataStreamChannel);
        }
    }

    @Override
    public void failed(Exception exception) {
        if (this.dataProducer != null) {
            this.dataProducer.failed(exception);
        }
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
        if (this.dataProducer != null) {
            this.dataProducer.releaseResources();
        }
    }
}

