/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support.classic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicServerExchangeHandler$1;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicServerExchangeHandler$2;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicServerExchangeHandler$State;
import org.apache.hc.core5.http.nio.support.classic.ContentInputStream;
import org.apache.hc.core5.http.nio.support.classic.SharedInputBuffer;
import org.apache.hc.core5.http.nio.support.classic.SharedOutputBuffer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public abstract class AbstractClassicServerExchangeHandler
implements AsyncServerExchangeHandler {
    private final int initialBufferSize;
    private final Executor executor;
    private final AtomicReference<AbstractClassicServerExchangeHandler$State> state;
    private final AtomicReference<Exception> exception;
    private volatile SharedInputBuffer inputBuffer;
    private volatile SharedOutputBuffer outputBuffer;

    public AbstractClassicServerExchangeHandler(int n2, Executor executor) {
        this.initialBufferSize = Args.positive(n2, "Initial buffer size");
        this.executor = Args.notNull(executor, "Executor");
        this.exception = new AtomicReference();
        this.state = new AtomicReference<AbstractClassicServerExchangeHandler$State>(AbstractClassicServerExchangeHandler$State.IDLE);
    }

    protected abstract void handle(HttpRequest var1, InputStream var2, HttpResponse var3, OutputStream var4, HttpContext var5) throws IOException, HttpException;

    public Exception getException() {
        return this.exception.get();
    }

    @Override
    public final void handleRequest(HttpRequest httpRequest, EntityDetails object, ResponseChannel object2, HttpContext httpContext) throws HttpException, IOException {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(200);
        AbstractClassicServerExchangeHandler$1 abstractClassicServerExchangeHandler$1 = new AbstractClassicServerExchangeHandler$1(this, basicHttpResponse, atomicBoolean);
        if (object != null) {
            this.inputBuffer = new SharedInputBuffer(this.initialBufferSize);
            object = new ContentInputStream(this.inputBuffer);
        } else {
            object = null;
        }
        this.outputBuffer = new SharedOutputBuffer(this.initialBufferSize);
        AbstractClassicServerExchangeHandler abstractClassicServerExchangeHandler = this;
        object2 = new AbstractClassicServerExchangeHandler$2(abstractClassicServerExchangeHandler, abstractClassicServerExchangeHandler.outputBuffer, atomicBoolean, (ResponseChannel)object2, basicHttpResponse, httpContext);
        if (this.state.compareAndSet(AbstractClassicServerExchangeHandler$State.IDLE, AbstractClassicServerExchangeHandler$State.ACTIVE)) {
            this.executor.execute(() -> this.lambda$handleRequest$0(httpRequest, (InputStream)object, abstractClassicServerExchangeHandler$1, (OutputStream)object2, httpContext));
        }
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        if (this.inputBuffer != null) {
            this.inputBuffer.updateCapacity(capacityChannel);
        }
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
        Asserts.notNull(this.inputBuffer, "Input buffer");
        this.inputBuffer.fill(byteBuffer);
    }

    @Override
    public final void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        Asserts.notNull(this.inputBuffer, "Input buffer");
        this.inputBuffer.markEndStream();
    }

    @Override
    public final int available() {
        Asserts.notNull(this.outputBuffer, "Output buffer");
        return this.outputBuffer.length();
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        Asserts.notNull(this.outputBuffer, "Output buffer");
        this.outputBuffer.flush(dataStreamChannel);
    }

    @Override
    public final void failed(Exception exception) {
        this.exception.compareAndSet(null, exception);
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
    }

    private /* synthetic */ void lambda$handleRequest$0(HttpRequest httpRequest, InputStream inputStream, HttpResponse httpResponse, OutputStream outputStream, HttpContext httpContext) {
        try {
            this.handle(httpRequest, inputStream, httpResponse, outputStream, httpContext);
            Closer.close(inputStream);
            outputStream.close();
            return;
        }
        catch (Exception exception) {
            this.exception.compareAndSet(null, exception);
            if (this.inputBuffer != null) {
                this.inputBuffer.abort();
            }
            this.outputBuffer.abort();
            return;
        }
        finally {
            this.state.set(AbstractClassicServerExchangeHandler$State.COMPLETED);
        }
    }
}

