/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support.classic;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.impl.nio.ExpandableBuffer;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
abstract class AbstractSharedBuffer
extends ExpandableBuffer {
    final ReentrantLock lock;
    final Condition condition;
    volatile boolean endStream;
    volatile boolean aborted;

    public AbstractSharedBuffer(ReentrantLock reentrantLock, int n2) {
        super(n2);
        this.lock = Args.notNull(reentrantLock, "Lock");
        this.condition = reentrantLock.newCondition();
    }

    @Override
    public boolean hasData() {
        this.lock.lock();
        try {
            boolean bl2 = super.hasData();
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int capacity() {
        this.lock.lock();
        try {
            int n2 = super.capacity();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int length() {
        this.lock.lock();
        try {
            int n2 = super.length();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void abort() {
        this.lock.lock();
        try {
            this.endStream = true;
            this.aborted = true;
            this.condition.signalAll();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        if (this.aborted) {
            return;
        }
        this.lock.lock();
        try {
            this.setInputMode();
            this.buffer().clear();
            this.endStream = false;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEndStream() {
        this.lock.lock();
        try {
            boolean bl2 = this.endStream && !super.hasData();
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }
}

