/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support.classic;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.http.nio.support.classic.ContentInputBuffer;
import org.apache.hc.core5.util.Args;

public class ContentInputStream
extends InputStream {
    private final ContentInputBuffer buffer;

    public ContentInputStream(ContentInputBuffer contentInputBuffer) {
        Args.notNull(contentInputBuffer, "Input buffer");
        this.buffer = contentInputBuffer;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.length();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        return this.buffer.read(byArray, n2, n3);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            return 0;
        }
        return this.buffer.read(byArray, 0, byArray.length);
    }

    @Override
    public int read() throws IOException {
        return this.buffer.read();
    }

    @Override
    public void close() throws IOException {
        byte[] byArray = new byte[1024];
        while (this.buffer.read(byArray, 0, byArray.length) >= 0) {
        }
        super.close();
    }
}

