/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestConnControl();

    @Override
    public void process(HttpRequest httpRequest, EntityDetails object, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        object = httpRequest.getMethod();
        if (Method.CONNECT.isSame((String)object)) {
            return;
        }
        if (!httpRequest.containsHeader("Connection")) {
            if (httpRequest.containsHeader("Upgrade")) {
                httpRequest.addHeader("Connection", "upgrade");
                return;
            }
            httpRequest.addHeader("Connection", "keep-alive");
        }
    }
}

