/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestContent
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestContent();
    private final boolean overwrite;

    public RequestContent() {
        this(false);
    }

    public RequestContent(boolean bl2) {
        this.overwrite = bl2;
    }

    @Override
    public void process(HttpRequest httpRequest, EntityDetails entityDetails, HttpContext object) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        String string = httpRequest.getMethod();
        if (Method.TRACE.isSame(string) && entityDetails != null) {
            throw new ProtocolException("TRACE request may not enclose an entity");
        }
        if (this.overwrite) {
            httpRequest.removeHeaders("Transfer-Encoding");
            httpRequest.removeHeaders("Content-Length");
        } else {
            if (httpRequest.containsHeader("Transfer-Encoding")) {
                throw new ProtocolException("Transfer-encoding header already present");
            }
            if (httpRequest.containsHeader("Content-Length")) {
                throw new ProtocolException("Content-Length header already present");
            }
        }
        if (entityDetails == null && this.isContentEnclosingMethod(string)) {
            httpRequest.addHeader("Content-Length", "0");
            return;
        }
        if (entityDetails != null) {
            this.validateOptionsContentType(httpRequest);
            object = object.getProtocolVersion();
            if (entityDetails.isChunked() || entityDetails.getContentLength() < 0L) {
                if (((ProtocolVersion)object).lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + object);
                }
                httpRequest.addHeader("Transfer-Encoding", "chunked");
                MessageSupport.addTrailerHeader(httpRequest, entityDetails);
            } else {
                httpRequest.addHeader("Content-Length", Long.toString(entityDetails.getContentLength()));
            }
            MessageSupport.addContentTypeHeader(httpRequest, entityDetails);
            MessageSupport.addContentEncodingHeader(httpRequest, entityDetails);
        }
    }

    private boolean isContentEnclosingMethod(String string) {
        return Method.POST.isSame(string) || Method.PUT.isSame(string) || Method.PATCH.isSame(string);
    }

    public void validateOptionsContentType(HttpRequest object) throws ProtocolException {
        if (Method.OPTIONS.isSame(object.getMethod()) && (object = object.getFirstHeader("Content-Type")) == null) {
            throw new ProtocolException("OPTIONS request must have Content-Type header");
        }
    }
}

