/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConnControl
implements HttpResponseInterceptor {
    public static final ResponseConnControl INSTANCE = new ResponseConnControl();

    @Override
    public void process(HttpResponse httpResponse, EntityDetails iterator, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpResponse, "HTTP response");
        Args.notNull(httpContext, "HTTP context");
        httpContext = HttpCoreContext.cast(httpContext);
        int n2 = httpResponse.getCode();
        if (n2 == 400 || n2 == 408 || n2 == 411 || n2 == 413 || n2 == 414 || n2 == 503 || n2 == 501) {
            httpResponse.setHeader("Connection", "close");
            return;
        }
        if (!httpResponse.containsHeader("Connection")) {
            ProtocolVersion protocolVersion = ((HttpCoreContext)httpContext).getProtocolVersion();
            if (iterator != null && iterator.getContentLength() < 0L && protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
                httpResponse.setHeader("Connection", "close");
                return;
            }
            iterator = ((HttpCoreContext)httpContext).getRequest();
            boolean bl2 = false;
            boolean bl3 = false;
            if (iterator != null) {
                iterator = MessageSupport.iterate((MessageHeaders)((Object)iterator), "Connection");
                while (iterator.hasNext()) {
                    HeaderElement headerElement = iterator.next();
                    if (headerElement.getName().equalsIgnoreCase("close")) {
                        bl2 = true;
                        break;
                    }
                    if (!headerElement.getName().equalsIgnoreCase("keep-alive")) continue;
                    bl3 = true;
                }
            }
            if (bl2) {
                httpResponse.addHeader("Connection", "close");
                return;
            }
            if (httpResponse.containsHeader("Upgrade")) {
                httpResponse.addHeader("Connection", "upgrade");
                return;
            }
            if (bl3) {
                httpResponse.addHeader("Connection", "keep-alive");
                return;
            }
            if (protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
                httpResponse.addHeader("Connection", "close");
            }
        }
    }
}

