/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.support;

import java.util.Iterator;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;

public abstract class AbstractMessageBuilder<T> {
    private ProtocolVersion version;
    private HeaderGroup headerGroup;

    protected AbstractMessageBuilder() {
    }

    protected void digest(HttpMessage httpMessage) {
        if (httpMessage == null) {
            return;
        }
        this.setVersion(httpMessage.getVersion());
        this.setHeaders(httpMessage.headerIterator());
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public AbstractMessageBuilder<T> setVersion(ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
        return this;
    }

    public Header[] getHeaders() {
        if (this.headerGroup != null) {
            return this.headerGroup.getHeaders();
        }
        return null;
    }

    public Header[] getHeaders(String string) {
        if (this.headerGroup != null) {
            return this.headerGroup.getHeaders(string);
        }
        return null;
    }

    public AbstractMessageBuilder<T> setHeaders(Header ... headerArray) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeaders(headerArray);
        return this;
    }

    public AbstractMessageBuilder<T> setHeaders(Iterator<Header> iterator) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        } else {
            this.headerGroup.clear();
        }
        while (iterator.hasNext()) {
            this.headerGroup.addHeader(iterator.next());
        }
        return this;
    }

    public Header[] getFirstHeaders() {
        if (this.headerGroup != null) {
            return this.headerGroup.getHeaders();
        }
        return null;
    }

    public Header getFirstHeader(String string) {
        if (this.headerGroup != null) {
            return this.headerGroup.getFirstHeader(string);
        }
        return null;
    }

    public Header getLastHeader(String string) {
        if (this.headerGroup != null) {
            return this.headerGroup.getLastHeader(string);
        }
        return null;
    }

    public AbstractMessageBuilder<T> addHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.addHeader(header);
        return this;
    }

    public AbstractMessageBuilder<T> addHeader(String string, String string2) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.addHeader(new BasicHeader(string, string2));
        return this;
    }

    public AbstractMessageBuilder<T> removeHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.removeHeader(header);
        return this;
    }

    public AbstractMessageBuilder<T> removeHeaders(String string) {
        if (string == null || this.headerGroup == null) {
            return this;
        }
        Iterator<Header> iterator = this.headerGroup.headerIterator();
        while (iterator.hasNext()) {
            Header header = iterator.next();
            if (!string.equalsIgnoreCase(header.getName())) continue;
            iterator.remove();
        }
        return this;
    }

    public AbstractMessageBuilder<T> setHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeader(header);
        return this;
    }

    public AbstractMessageBuilder<T> setHeader(String string, String string2) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeader(new BasicHeader(string, string2));
        return this;
    }

    protected abstract T build();
}

