/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.support.AbstractMessageBuilder;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.TextUtils;

public abstract class AbstractRequestBuilder<T>
extends AbstractMessageBuilder<T> {
    private final String method;
    private String scheme;
    private URIAuthority authority;
    private String path;
    private Charset charset;
    private List<NameValuePair> parameters;
    private boolean absoluteRequestUri;

    protected AbstractRequestBuilder(String string) {
        this.method = string;
    }

    protected AbstractRequestBuilder(Method method) {
        this(method.name());
    }

    protected AbstractRequestBuilder(String string, URI uRI) {
        this.method = string;
        this.setUri(uRI);
    }

    protected AbstractRequestBuilder(Method method, URI uRI) {
        this(method.name(), uRI);
    }

    protected AbstractRequestBuilder(Method method, String string) {
        this(method.name(), string != null ? URI.create(string) : null);
    }

    protected AbstractRequestBuilder(String string, String string2) {
        this(string, string2 != null ? URI.create(string2) : null);
    }

    protected void digest(HttpRequest httpRequest) {
        if (httpRequest == null) {
            return;
        }
        this.setScheme(httpRequest.getScheme());
        this.setAuthority(httpRequest.getAuthority());
        this.setPath(httpRequest.getPath());
        this.parameters = null;
        super.digest(httpRequest);
    }

    public String getMethod() {
        return this.method;
    }

    @Override
    public AbstractRequestBuilder<T> setVersion(ProtocolVersion protocolVersion) {
        super.setVersion(protocolVersion);
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public AbstractRequestBuilder<T> setScheme(String string) {
        this.scheme = string;
        return this;
    }

    public URIAuthority getAuthority() {
        return this.authority;
    }

    public AbstractRequestBuilder<T> setAuthority(URIAuthority uRIAuthority) {
        this.authority = uRIAuthority;
        return this;
    }

    public AbstractRequestBuilder<T> setHttpHost(HttpHost httpHost) {
        if (httpHost == null) {
            return this;
        }
        this.authority = new URIAuthority(httpHost);
        this.scheme = httpHost.getSchemeName();
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public AbstractRequestBuilder<T> setPath(String string) {
        this.path = string;
        return this;
    }

    public URI getUri() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.authority != null) {
            stringBuilder.append(this.scheme != null ? this.scheme : URIScheme.HTTP.id).append("://");
            stringBuilder.append(this.authority.getHostName());
            if (this.authority.getPort() >= 0) {
                stringBuilder.append(":").append(this.authority.getPort());
            }
        }
        if (this.path == null) {
            stringBuilder.append("/");
        } else {
            if (stringBuilder.length() > 0 && !this.path.startsWith("/")) {
                stringBuilder.append("/");
            }
            stringBuilder.append(this.path);
        }
        return URI.create(stringBuilder.toString());
    }

    public AbstractRequestBuilder<T> setUri(URI object) {
        if (object == null) {
            this.scheme = null;
            this.authority = null;
            this.path = null;
        } else {
            this.scheme = ((URI)object).getScheme();
            if (((URI)object).getHost() != null) {
                this.authority = new URIAuthority(((URI)object).getRawUserInfo(), ((URI)object).getHost(), ((URI)object).getPort());
            } else {
                if (((URI)object).getRawAuthority() != null) {
                    try {
                        this.authority = URIAuthority.create(((URI)object).getRawAuthority());
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                this.authority = null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = ((URI)object).getRawPath();
            if (!TextUtils.isBlank(string)) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append("/");
            }
            object = ((URI)object).getRawQuery();
            if (object != null) {
                stringBuilder.append('?').append((String)object);
            }
            this.path = stringBuilder.toString();
        }
        return this;
    }

    public AbstractRequestBuilder<T> setUri(String string) {
        this.setUri(string != null ? URI.create(string) : null);
        return this;
    }

    @Override
    public AbstractRequestBuilder<T> setHeaders(Header ... headerArray) {
        super.setHeaders(headerArray);
        return this;
    }

    @Override
    public AbstractRequestBuilder<T> addHeader(Header header) {
        super.addHeader(header);
        return this;
    }

    @Override
    public AbstractRequestBuilder<T> addHeader(String string, String string2) {
        super.addHeader(string, string2);
        return this;
    }

    @Override
    public AbstractRequestBuilder<T> removeHeader(Header header) {
        super.removeHeader(header);
        return this;
    }

    @Override
    public AbstractRequestBuilder<T> removeHeaders(String string) {
        super.removeHeaders(string);
        return this;
    }

    @Override
    public AbstractRequestBuilder<T> setHeader(Header header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public AbstractRequestBuilder<T> setHeader(String string, String string2) {
        super.setHeader(string, string2);
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public AbstractRequestBuilder<T> setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public List<NameValuePair> getParameters() {
        if (this.parameters != null) {
            return new ArrayList<NameValuePair>(this.parameters);
        }
        return null;
    }

    public AbstractRequestBuilder<T> addParameter(NameValuePair nameValuePair) {
        if (nameValuePair == null) {
            return this;
        }
        if (this.parameters == null) {
            this.parameters = new LinkedList<NameValuePair>();
        }
        this.parameters.add(nameValuePair);
        return this;
    }

    public AbstractRequestBuilder<T> addParameter(String string, String string2) {
        return this.addParameter(new BasicNameValuePair(string, string2));
    }

    public AbstractRequestBuilder<T> addParameters(NameValuePair ... nameValuePairArray) {
        for (NameValuePair nameValuePair : nameValuePairArray) {
            this.addParameter(nameValuePair);
        }
        return this;
    }

    public boolean isAbsoluteRequestUri() {
        return this.absoluteRequestUri;
    }

    public AbstractRequestBuilder<T> setAbsoluteRequestUri(boolean bl2) {
        this.absoluteRequestUri = bl2;
        return this;
    }
}

