/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.support;

import java.util.Arrays;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.support.AbstractResponseBuilder;
import org.apache.hc.core5.util.Args;

public class BasicResponseBuilder
extends AbstractResponseBuilder<BasicHttpResponse> {
    protected BasicResponseBuilder(int n2) {
        super(n2);
    }

    public static BasicResponseBuilder create(int n2) {
        Args.checkRange(n2, 100, 599, "HTTP status code");
        return new BasicResponseBuilder(n2);
    }

    public static BasicResponseBuilder copy(HttpResponse httpResponse) {
        Args.notNull(httpResponse, "HTTP response");
        BasicResponseBuilder basicResponseBuilder = new BasicResponseBuilder(httpResponse.getCode());
        basicResponseBuilder.digest(httpResponse);
        return basicResponseBuilder;
    }

    @Override
    public BasicResponseBuilder setVersion(ProtocolVersion protocolVersion) {
        super.setVersion(protocolVersion);
        return this;
    }

    @Override
    public BasicResponseBuilder setHeaders(Header ... headerArray) {
        super.setHeaders(headerArray);
        return this;
    }

    @Override
    public BasicResponseBuilder addHeader(Header header) {
        super.addHeader(header);
        return this;
    }

    @Override
    public BasicResponseBuilder addHeader(String string, String string2) {
        super.addHeader(string, string2);
        return this;
    }

    @Override
    public BasicResponseBuilder removeHeader(Header header) {
        super.removeHeader(header);
        return this;
    }

    @Override
    public BasicResponseBuilder removeHeaders(String string) {
        super.removeHeaders(string);
        return this;
    }

    @Override
    public BasicResponseBuilder setHeader(Header header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public BasicResponseBuilder setHeader(String string, String string2) {
        super.setHeader(string, string2);
        return this;
    }

    @Override
    public BasicHttpResponse build() {
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(this.getStatus());
        basicHttpResponse.setVersion(this.getVersion());
        basicHttpResponse.setHeaders(this.getHeaders());
        return basicHttpResponse;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BasicResponseBuilder [status=");
        stringBuilder.append(this.getStatus());
        stringBuilder.append(", headerGroup=");
        stringBuilder.append(Arrays.toString(this.getHeaders()));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

