/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.support;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.support.Expectation;
import org.apache.hc.core5.util.TextUtils;

@Internal
public class ExpectSupport {
    public static Expectation parse(HttpRequest object, EntityDetails entityDetails) throws ProtocolException {
        if (object.getVersion() != null && object.getVersion().lessEquals(HttpVersion.HTTP_1_0)) {
            return null;
        }
        AtomicReference atomicReference = new AtomicReference();
        MessageSupport.parseTokens(object, "Expect", string -> {
            if (string.equalsIgnoreCase("100-continue")) {
                atomicReference.compareAndSet(null, Expectation.CONTINUE);
                return;
            }
            if (!TextUtils.isBlank(string)) {
                atomicReference.set(Expectation.UNKNOWN);
            }
        });
        object = (Expectation)((Object)atomicReference.get());
        if (object == Expectation.CONTINUE && entityDetails == null) {
            throw new ProtocolException("Expect-Continue request without an enclosed entity");
        }
        return object;
    }
}

