/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.config;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.util.Args;

public class H2Config$Builder {
    private int headerTableSize = 8192;
    private boolean pushEnabled = true;
    private int maxConcurrentStreams = 250;
    private int initialWindowSize = 65535;
    private int maxFrameSize = 65536;
    private int maxHeaderListSize = 0xFFFFFF;
    private boolean compressionEnabled = true;
    private int maxContinuations = 100;

    H2Config$Builder() {
    }

    public H2Config$Builder setHeaderTableSize(int n2) {
        Args.notNegative(n2, "Header table size");
        this.headerTableSize = n2;
        return this;
    }

    public H2Config$Builder setPushEnabled(boolean bl2) {
        this.pushEnabled = bl2;
        return this;
    }

    public H2Config$Builder setMaxConcurrentStreams(int n2) {
        Args.positive(n2, "Max concurrent streams");
        this.maxConcurrentStreams = n2;
        return this;
    }

    public H2Config$Builder setInitialWindowSize(int n2) {
        Args.positive(n2, "Initial window size");
        this.initialWindowSize = n2;
        return this;
    }

    public H2Config$Builder setMaxFrameSize(int n2) {
        this.maxFrameSize = Args.checkRange(n2, 16384, 0xFFFFFF, "Invalid max frame size");
        return this;
    }

    public H2Config$Builder setMaxHeaderListSize(int n2) {
        Args.positive(n2, "Max header list size");
        this.maxHeaderListSize = n2;
        return this;
    }

    public H2Config$Builder setCompressionEnabled(boolean bl2) {
        this.compressionEnabled = bl2;
        return this;
    }

    @Internal
    public H2Config$Builder setMaxContinuations(int n2) {
        Args.positive(n2, "Max continuations");
        this.maxContinuations = n2;
        return this;
    }

    public H2Config build() {
        return new H2Config(this.headerTableSize, this.pushEnabled, this.maxConcurrentStreams, this.initialWindowSize, this.maxFrameSize, this.maxHeaderListSize, this.compressionEnabled, this.maxContinuations);
    }
}

