/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.config;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http2.config.H2Config$Builder;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2Config {
    public static final H2Config DEFAULT = H2Config.custom().build();
    public static final H2Config INIT = H2Config.initial().build();
    private final int headerTableSize;
    private final boolean pushEnabled;
    private final int maxConcurrentStreams;
    private final int initialWindowSize;
    private final int maxFrameSize;
    private final int maxHeaderListSize;
    private final boolean compressionEnabled;
    private final int maxContinuations;
    private static final int INIT_HEADER_TABLE_SIZE = 4096;
    private static final boolean INIT_ENABLE_PUSH = true;
    private static final int INIT_MAX_FRAME_SIZE = 16384;
    private static final int INIT_WINDOW_SIZE = 65535;
    private static final int INIT_CONCURRENT_STREAM = 250;

    H2Config(int n2, boolean bl2, int n3, int n4, int n5, int n6, boolean bl3, int n7) {
        this.headerTableSize = n2;
        this.pushEnabled = bl2;
        this.maxConcurrentStreams = n3;
        this.initialWindowSize = n4;
        this.maxFrameSize = n5;
        this.maxHeaderListSize = n6;
        this.compressionEnabled = bl3;
        this.maxContinuations = n7;
    }

    public int getHeaderTableSize() {
        return this.headerTableSize;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    @Internal
    public int getMaxContinuations() {
        return this.maxContinuations;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[headerTableSize=").append(this.headerTableSize).append(", pushEnabled=").append(this.pushEnabled).append(", maxConcurrentStreams=").append(this.maxConcurrentStreams).append(", initialWindowSize=").append(this.initialWindowSize).append(", maxFrameSize=").append(this.maxFrameSize).append(", maxHeaderListSize=").append(this.maxHeaderListSize).append(", compressionEnabled=").append(this.compressionEnabled).append(", maxContinuations=").append(this.maxContinuations).append("]");
        return stringBuilder.toString();
    }

    public static H2Config$Builder custom() {
        return new H2Config$Builder();
    }

    public static H2Config$Builder initial() {
        return new H2Config$Builder().setHeaderTableSize(4096).setPushEnabled(true).setMaxConcurrentStreams(Integer.MAX_VALUE).setMaxFrameSize(16384).setInitialWindowSize(65535).setMaxHeaderListSize(Integer.MAX_VALUE);
    }

    public static H2Config$Builder copy(H2Config h2Config) {
        Args.notNull(h2Config, "Connection config");
        return new H2Config$Builder().setHeaderTableSize(h2Config.getHeaderTableSize()).setPushEnabled(h2Config.isPushEnabled()).setMaxConcurrentStreams(h2Config.getMaxConcurrentStreams()).setInitialWindowSize(h2Config.getInitialWindowSize()).setMaxFrameSize(h2Config.getMaxFrameSize()).setMaxHeaderListSize(h2Config.getMaxHeaderListSize()).setCompressionEnabled(h2Config.isCompressionEnabled());
    }
}

