/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.frame;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.config.H2Setting;
import org.apache.hc.core5.http2.frame.FrameFlag;
import org.apache.hc.core5.http2.frame.FrameType;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.util.Args;

public abstract class FrameFactory {
    public RawFrame createSettings(H2Setting ... h2SettingArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(h2SettingArray.length * 12);
        for (H2Setting h2Setting : h2SettingArray) {
            byteBuffer.putShort((short)h2Setting.getCode());
            byteBuffer.putInt(h2Setting.getValue());
        }
        byteBuffer.flip();
        return new RawFrame(FrameType.SETTINGS.getValue(), 0, 0, byteBuffer);
    }

    public RawFrame createSettingsAck() {
        return new RawFrame(FrameType.SETTINGS.getValue(), FrameFlag.ACK.getValue(), 0, null);
    }

    public RawFrame createResetStream(int n2, H2Error h2Error) {
        Args.notNull(h2Error, "Error");
        return this.createResetStream(n2, h2Error.getCode());
    }

    public RawFrame createResetStream(int n2, int n3) {
        Args.positive(n2, "Stream id");
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n3);
        byteBuffer.flip();
        return new RawFrame(FrameType.RST_STREAM.getValue(), 0, n2, byteBuffer);
    }

    public RawFrame createPing(ByteBuffer byteBuffer) {
        Args.notNull(byteBuffer, "Opaque data");
        Args.check(byteBuffer.remaining() == 8, "Opaque data length must be equal 8");
        return new RawFrame(FrameType.PING.getValue(), 0, 0, byteBuffer);
    }

    public RawFrame createPingAck(ByteBuffer byteBuffer) {
        Args.notNull(byteBuffer, "Opaque data");
        Args.check(byteBuffer.remaining() == 8, "Opaque data length must be equal 8");
        return new RawFrame(FrameType.PING.getValue(), FrameFlag.ACK.value, 0, byteBuffer);
    }

    public RawFrame createGoAway(int n2, H2Error h2Error, String string) {
        Args.notNegative(n2, "Last stream id");
        string = string != null ? string.getBytes(StandardCharsets.US_ASCII) : null;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 + (string != null ? ((String)string).length : 0));
        byteBuffer.putInt(n2);
        byteBuffer.putInt(h2Error.getCode());
        if (string != null) {
            byteBuffer.put((byte[])string);
        }
        byteBuffer.flip();
        return new RawFrame(FrameType.GOAWAY.getValue(), 0, 0, byteBuffer);
    }

    public abstract RawFrame createHeaders(int var1, ByteBuffer var2, boolean var3, boolean var4);

    public abstract RawFrame createContinuation(int var1, ByteBuffer var2, boolean var3);

    public abstract RawFrame createPushPromise(int var1, ByteBuffer var2, boolean var3);

    public abstract RawFrame createData(int var1, ByteBuffer var2, boolean var3);

    public RawFrame createWindowUpdate(int n2, int n3) {
        Args.notNegative(n2, "Stream id");
        Args.positive(n3, "Increment");
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n3);
        byteBuffer.flip();
        return new RawFrame(FrameType.WINDOW_UPDATE.getValue(), 0, n2, byteBuffer);
    }
}

