/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.frame;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.config.H2Param;
import org.apache.hc.core5.http2.frame.FrameFlag;
import org.apache.hc.core5.http2.frame.FramePrinter$1;
import org.apache.hc.core5.http2.frame.FrameType;
import org.apache.hc.core5.http2.frame.RawFrame;

@Internal
public final class FramePrinter {
    public final void printFrameInfo(RawFrame rawFrame, Appendable appendable) throws IOException {
        appendable.append("stream ").append(Integer.toString(rawFrame.getStreamId())).append(" frame: ");
        FrameType frameType = FrameType.valueOf(rawFrame.getType());
        appendable.append(Objects.toString((Object)frameType)).append(" (0x").append(Integer.toHexString(rawFrame.getType())).append("); flags: ");
        int n2 = rawFrame.getFlags();
        if (n2 > 0) {
            switch (frameType) {
                case SETTINGS: 
                case PING: {
                    if ((n2 & FrameFlag.ACK.value) <= 0) break;
                    appendable.append(FrameFlag.ACK.name()).append(" ");
                    break;
                }
                case DATA: {
                    if ((n2 & FrameFlag.END_STREAM.value) > 0) {
                        appendable.append(FrameFlag.END_STREAM.name()).append(" ");
                    }
                    if ((n2 & FrameFlag.PADDED.value) <= 0) break;
                    appendable.append(FrameFlag.PADDED.name()).append(" ");
                    break;
                }
                case HEADERS: {
                    if ((n2 & FrameFlag.END_STREAM.value) > 0) {
                        appendable.append(FrameFlag.END_STREAM.name()).append(" ");
                    }
                    if ((n2 & FrameFlag.END_HEADERS.value) > 0) {
                        appendable.append(FrameFlag.END_HEADERS.name()).append(" ");
                    }
                    if ((n2 & FrameFlag.PADDED.value) > 0) {
                        appendable.append(FrameFlag.PADDED.name()).append(" ");
                    }
                    if ((n2 & FrameFlag.PRIORITY.value) <= 0) break;
                    appendable.append(FrameFlag.PRIORITY.name()).append(" ");
                    break;
                }
                case PUSH_PROMISE: {
                    if ((n2 & FrameFlag.END_HEADERS.value) > 0) {
                        appendable.append(FrameFlag.END_HEADERS.name()).append(" ");
                    }
                    if ((n2 & FrameFlag.PADDED.value) <= 0) break;
                    appendable.append(FrameFlag.PADDED.name()).append(" ");
                    break;
                }
                case CONTINUATION: {
                    if ((n2 & FrameFlag.END_HEADERS.value) <= 0) break;
                    appendable.append(FrameFlag.END_HEADERS.name()).append(" ");
                }
            }
        }
        appendable.append("(0x").append(Integer.toHexString(n2)).append("); length: ").append(Integer.toString(rawFrame.getLength()));
    }

    public final void printPayload(RawFrame rawFrame, Appendable appendable) throws IOException {
        Enum enum_ = FrameType.valueOf(rawFrame.getType());
        ByteBuffer byteBuffer = rawFrame.getPayloadContent();
        if (byteBuffer != null) {
            switch (FramePrinter$1.$SwitchMap$org$apache$hc$core5$http2$frame$FrameType[enum_.ordinal()]) {
                case 1: {
                    if (byteBuffer.remaining() % 6 == 0) {
                        while (byteBuffer.hasRemaining()) {
                            short s2 = byteBuffer.getShort();
                            enum_ = H2Param.valueOf(s2);
                            int n2 = byteBuffer.getInt();
                            if (enum_ != null) {
                                appendable.append(enum_.name());
                            } else {
                                appendable.append("0x").append(Integer.toHexString(s2));
                            }
                            appendable.append(": ").append(Integer.toString(n2)).append("\r\n");
                        }
                        break;
                    }
                    appendable.append("Invalid\r\n");
                    return;
                }
                case 7: {
                    if (byteBuffer.remaining() == 4) {
                        appendable.append("Code ");
                        int n3 = byteBuffer.getInt();
                        enum_ = H2Error.getByCode(n3);
                        if (enum_ != null) {
                            appendable.append(enum_.name());
                        } else {
                            appendable.append("0x").append(Integer.toHexString(n3));
                        }
                        appendable.append("\r\n");
                        return;
                    }
                    appendable.append("Invalid\r\n");
                    return;
                }
                case 8: {
                    if (byteBuffer.remaining() >= 8) {
                        int n4 = byteBuffer.getInt();
                        appendable.append("Last stream ").append(Integer.toString(n4)).append("\r\n");
                        appendable.append("Code ");
                        int n5 = byteBuffer.getInt();
                        H2Error h2Error = H2Error.getByCode(n5);
                        if (h2Error != null) {
                            appendable.append(h2Error.name());
                        } else {
                            appendable.append("0x").append(Integer.toHexString(n5));
                        }
                        appendable.append("\r\n");
                        byte[] byArray = new byte[byteBuffer.remaining()];
                        byteBuffer.get(byArray);
                        appendable.append(new String(byArray, StandardCharsets.US_ASCII));
                        appendable.append("\r\n");
                        return;
                    }
                    appendable.append("Invalid\r\n");
                    return;
                }
                case 9: {
                    if (byteBuffer.remaining() == 4) {
                        int n6 = byteBuffer.getInt();
                        appendable.append("Increment ").append(Integer.toString(n6)).append("\r\n");
                        return;
                    }
                    appendable.append("Invalid\r\n");
                    return;
                }
                case 5: {
                    if (byteBuffer.remaining() > 4) {
                        int n7 = byteBuffer.getInt();
                        appendable.append("Promised stream ").append(Integer.toString(n7)).append("\r\n");
                        this.printData(byteBuffer, appendable);
                        return;
                    }
                    appendable.append("Invalid\r\n");
                    return;
                }
                default: {
                    this.printData(rawFrame.getPayload(), appendable);
                }
            }
        }
    }

    public final void printData(ByteBuffer byteBuffer, Appendable appendable) throws IOException {
        byteBuffer = byteBuffer.duplicate();
        byte[] byArray = new byte[16];
        while (byteBuffer.hasRemaining()) {
            int n2;
            int n3 = Math.min(byteBuffer.remaining(), byArray.length);
            byteBuffer.get(byArray, 0, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                char c2 = (char)byArray[n2];
                if (c2 > ' ' && c2 <= '\u007f') {
                    appendable.append(c2);
                    continue;
                }
                if (Character.isWhitespace(c2)) {
                    appendable.append(' ');
                    continue;
                }
                appendable.append('.');
            }
            for (n2 = n3; n2 < 17; ++n2) {
                appendable.append(' ');
            }
            for (n2 = 0; n2 < n3; ++n2) {
                appendable.append(' ');
                int n4 = byArray[n2] & 0xFF;
                String string = Integer.toHexString(n4);
                if (string.length() == 1) {
                    appendable.append("0");
                }
                appendable.append(string);
            }
            appendable.append("\r\n");
        }
    }
}

