/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http2.hpack.HPackException;
import org.apache.hc.core5.http2.hpack.HPackHeader;
import org.apache.hc.core5.http2.hpack.HPackRepresentation;
import org.apache.hc.core5.http2.hpack.HeaderListConstraintException;
import org.apache.hc.core5.http2.hpack.Huffman;
import org.apache.hc.core5.http2.hpack.InboundDynamicTable;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;

@Internal
public final class HPackDecoder {
    private static final String UNEXPECTED_EOS = "Unexpected end of HPACK data";
    private static final String MAX_LIMIT_EXCEEDED = "Max integer exceeded";
    private final InboundDynamicTable dynamicTable;
    private final ByteArrayBuffer contentBuf;
    private final CharsetDecoder charsetDecoder;
    private CharBuffer tmpBuf;
    private int maxTableSize;
    private int maxListSize;

    HPackDecoder(InboundDynamicTable inboundDynamicTable, CharsetDecoder charsetDecoder) {
        this.dynamicTable = Objects.requireNonNull(inboundDynamicTable);
        this.contentBuf = new ByteArrayBuffer(256);
        this.charsetDecoder = charsetDecoder;
        this.maxTableSize = this.dynamicTable.getMaxSize();
        this.maxListSize = Integer.MAX_VALUE;
    }

    HPackDecoder(InboundDynamicTable inboundDynamicTable, Charset charset) {
        this(inboundDynamicTable, charset != null && !StandardCharsets.US_ASCII.equals(charset) ? charset.newDecoder() : null);
    }

    public HPackDecoder(int n2, Charset charset) {
        this(new InboundDynamicTable(n2), charset);
    }

    public HPackDecoder(int n2, CharsetDecoder charsetDecoder) {
        this(new InboundDynamicTable(n2), charsetDecoder);
    }

    static int readByte(ByteBuffer byteBuffer) throws HPackException {
        if (!byteBuffer.hasRemaining()) {
            throw new HPackException(UNEXPECTED_EOS);
        }
        return byteBuffer.get() & 0xFF;
    }

    static int peekByte(ByteBuffer byteBuffer) throws HPackException {
        if (!byteBuffer.hasRemaining()) {
            throw new HPackException(UNEXPECTED_EOS);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.get() & 0xFF;
        byteBuffer.position(n2);
        return n3;
    }

    static int decodeInt(ByteBuffer byteBuffer, int n2) throws HPackException {
        n2 = 255 >>> 8 - n2;
        int n3 = HPackDecoder.readByte(byteBuffer) & n2;
        if (n3 < n2) {
            return n3;
        }
        for (n2 = 0; n2 < 32; n2 += 7) {
            int n4 = HPackDecoder.readByte(byteBuffer);
            if ((n4 & 0x80) != 0) {
                n3 += (n4 & 0x7F) << n2;
                continue;
            }
            if (n2 == 28 && (n4 & 0xF8) != 0) break;
            return n3 += n4 << n2;
        }
        throw new HPackException(MAX_LIMIT_EXCEEDED);
    }

    static void decodePlainString(ByteArrayBuffer byteArrayBuffer, ByteBuffer byteBuffer) throws HPackException {
        int n2;
        int n3 = HPackDecoder.decodeInt(byteBuffer, 7);
        if (n3 > (n2 = byteBuffer.remaining())) {
            throw new HPackException(UNEXPECTED_EOS);
        }
        int n4 = byteBuffer.limit();
        byteBuffer.limit(n4 - (n2 - n3));
        byteArrayBuffer.append(byteBuffer);
        byteBuffer.limit(n4);
    }

    static void decodeHuffman(ByteArrayBuffer byteArrayBuffer, ByteBuffer byteBuffer) throws HPackException {
        int n2 = HPackDecoder.decodeInt(byteBuffer, 7);
        if (n2 > byteBuffer.remaining()) {
            throw new HPackException(UNEXPECTED_EOS);
        }
        int n3 = byteBuffer.limit();
        ByteBuffer byteBuffer2 = byteBuffer;
        byteBuffer2.limit(byteBuffer2.position() + n2);
        Huffman.DECODER.decode(byteArrayBuffer, byteBuffer);
        byteBuffer.limit(n3);
    }

    final void decodeString(ByteArrayBuffer byteArrayBuffer, ByteBuffer byteBuffer) throws HPackException {
        int n2 = HPackDecoder.peekByte(byteBuffer);
        if ((n2 & 0x80) == 128) {
            HPackDecoder.decodeHuffman(byteArrayBuffer, byteBuffer);
            return;
        }
        HPackDecoder.decodePlainString(byteArrayBuffer, byteBuffer);
    }

    final int getTmpBufSize() {
        if (this.tmpBuf == null) {
            return 0;
        }
        return this.tmpBuf.capacity();
    }

    private void clearState() {
        if (this.tmpBuf != null) {
            this.tmpBuf.clear();
        }
        if (this.charsetDecoder != null) {
            this.charsetDecoder.reset();
        }
        this.contentBuf.clear();
    }

    private void expandCapacity(int n2) {
        CharBuffer charBuffer = this.tmpBuf;
        this.tmpBuf = CharBuffer.allocate(n2);
        charBuffer.flip();
        this.tmpBuf.put(charBuffer);
    }

    private void ensureCapacity(int n2) {
        if (this.tmpBuf == null) {
            this.tmpBuf = CharBuffer.allocate(Math.max(256, n2));
        }
        if ((n2 = this.tmpBuf.position() + n2) > this.tmpBuf.capacity()) {
            this.expandCapacity(n2);
        }
    }

    final int decodeString(ByteBuffer byteBuffer, StringBuilder stringBuilder) throws HPackException, CharacterCodingException {
        this.clearState();
        HPackDecoder hPackDecoder = this;
        hPackDecoder.decodeString(hPackDecoder.contentBuf, byteBuffer);
        int n2 = this.contentBuf.length();
        if (n2 == 0) {
            return 0;
        }
        if (this.charsetDecoder == null) {
            stringBuilder.ensureCapacity(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append((char)(this.contentBuf.byteAt(i2) & 0xFF));
            }
        } else {
            CoderResult coderResult;
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.contentBuf.array(), 0, n2);
            while (byteBuffer2.hasRemaining()) {
                this.ensureCapacity(byteBuffer2.remaining());
                coderResult = this.charsetDecoder.decode(byteBuffer2, this.tmpBuf, true);
                if (!coderResult.isError()) continue;
                coderResult.throwException();
            }
            this.ensureCapacity(8);
            coderResult = this.charsetDecoder.flush(this.tmpBuf);
            if (coderResult.isError()) {
                coderResult.throwException();
            }
            this.tmpBuf.flip();
            stringBuilder.append(this.tmpBuf);
        }
        return n2;
    }

    final HPackHeader decodeLiteralHeader(ByteBuffer byteBuffer, HPackRepresentation hPackRepresentation) throws HPackException, CharacterCodingException {
        String string;
        int n2;
        Object object;
        int n3 = hPackRepresentation == HPackRepresentation.WITH_INDEXING ? 6 : 4;
        if ((n3 = HPackDecoder.decodeInt(byteBuffer, n3)) == 0) {
            object = new StringBuilder();
            n2 = this.decodeString(byteBuffer, (StringBuilder)object);
            string = ((StringBuilder)object).toString();
        } else {
            object = this.dynamicTable.getHeader(n3);
            if (object == null) {
                throw new HPackException("Invalid header index");
            }
            string = ((HPackHeader)object).getName();
            n2 = ((HPackHeader)object).getNameLen();
        }
        object = new StringBuilder();
        int n4 = this.decodeString(byteBuffer, (StringBuilder)object);
        object = ((StringBuilder)object).toString();
        HPackHeader hPackHeader = new HPackHeader(string, n2, (String)object, n4, hPackRepresentation == HPackRepresentation.NEVER_INDEXED);
        if (hPackRepresentation == HPackRepresentation.WITH_INDEXING) {
            this.dynamicTable.add(hPackHeader);
        }
        return hPackHeader;
    }

    final HPackHeader decodeIndexedHeader(ByteBuffer byteBuffer) throws HPackException {
        int n2 = HPackDecoder.decodeInt(byteBuffer, 7);
        HPackHeader hPackHeader = this.dynamicTable.getHeader(n2);
        if (hPackHeader == null) {
            throw new HPackException("Invalid header index");
        }
        return hPackHeader;
    }

    public final Header decodeHeader(ByteBuffer object) throws HPackException {
        if ((object = this.decodeHPackHeader((ByteBuffer)object)) != null) {
            return new BasicHeader(((HPackHeader)object).getName(), ((HPackHeader)object).getValue(), ((HPackHeader)object).isSensitive());
        }
        return null;
    }

    final HPackHeader decodeHPackHeader(ByteBuffer byteBuffer) throws HPackException {
        try {
            while (byteBuffer.hasRemaining()) {
                int n2 = HPackDecoder.peekByte(byteBuffer);
                if ((n2 & 0x80) == 128) {
                    return this.decodeIndexedHeader(byteBuffer);
                }
                if ((n2 & 0xC0) == 64) {
                    return this.decodeLiteralHeader(byteBuffer, HPackRepresentation.WITH_INDEXING);
                }
                if ((n2 & 0xF0) == 0) {
                    return this.decodeLiteralHeader(byteBuffer, HPackRepresentation.WITHOUT_INDEXING);
                }
                if ((n2 & 0xF0) == 16) {
                    return this.decodeLiteralHeader(byteBuffer, HPackRepresentation.NEVER_INDEXED);
                }
                if ((n2 & 0xE0) == 32) {
                    n2 = HPackDecoder.decodeInt(byteBuffer, 5);
                    if (n2 > this.maxTableSize) {
                        throw new HPackException("Requested dynamic header table size exceeds maximum size: " + n2);
                    }
                    this.dynamicTable.setMaxSize(n2);
                    continue;
                }
                throw new HPackException("Unexpected header first byte: 0x" + Integer.toHexString(n2));
            }
            return null;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new HPackException(characterCodingException.getMessage(), characterCodingException);
        }
    }

    public final List<Header> decodeHeaders(ByteBuffer byteBuffer) throws HPackException {
        HPackHeader hPackHeader;
        boolean bl2 = this.maxListSize < Integer.MAX_VALUE;
        int n2 = 0;
        ArrayList<Header> arrayList = new ArrayList<Header>();
        while (byteBuffer.hasRemaining() && (hPackHeader = this.decodeHPackHeader(byteBuffer)) != null) {
            if (bl2 && (n2 += hPackHeader.getTotalSize()) >= this.maxListSize) {
                throw new HeaderListConstraintException("Maximum header list size exceeded");
            }
            arrayList.add(new BasicHeader(hPackHeader.getName(), hPackHeader.getValue(), hPackHeader.isSensitive()));
        }
        return arrayList;
    }

    public final int getMaxTableSize() {
        return this.maxTableSize;
    }

    public final void setMaxTableSize(int n2) {
        Args.notNegative(n2, "Max table size");
        this.maxTableSize = n2;
        this.dynamicTable.setMaxSize(Math.min(this.dynamicTable.getMaxSize(), n2));
    }

    public final int getMaxListSize() {
        return this.maxListSize;
    }

    public final void setMaxListSize(int n2) {
        Args.notNegative(n2, "Max list size");
        this.maxListSize = n2;
    }
}

