/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import org.apache.hc.core5.http.Header;

final class HPackHeader
implements Header {
    private static final int ENTRY_SIZE_OVERHEAD = 32;
    private final String name;
    private final int nameLen;
    private final String value;
    private final int valueLen;
    private final boolean sensitive;

    HPackHeader(String string, int n2, String string2, int n3, boolean bl2) {
        this.name = string;
        this.nameLen = n2;
        this.value = string2;
        this.valueLen = n3;
        this.sensitive = bl2;
    }

    HPackHeader(String string, String string2, boolean bl2) {
        String string3 = string;
        String string4 = string2;
        this(string3, string3.length(), string4, string4.length(), bl2);
    }

    HPackHeader(String string, String string2) {
        this(string, string2, false);
    }

    HPackHeader(Header header) {
        this(header.getName(), header.getValue(), header.isSensitive());
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final int getNameLen() {
        return this.nameLen;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public final int getValueLen() {
        return this.valueLen;
    }

    @Override
    public final boolean isSensitive() {
        return this.sensitive;
    }

    public final int getTotalSize() {
        return this.nameLen + this.valueLen + 32;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append(": ");
        if (this.value != null) {
            stringBuilder.append(this.value);
        }
        return stringBuilder.toString();
    }
}

