/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import java.nio.ByteBuffer;
import org.apache.hc.core5.http2.hpack.HPackException;
import org.apache.hc.core5.http2.hpack.HuffmanNode;
import org.apache.hc.core5.util.ByteArrayBuffer;

final class HuffmanDecoder {
    private final HuffmanNode root;

    HuffmanDecoder(int[] nArray, byte[] byArray) {
        this.root = HuffmanDecoder.buildTree(nArray, byArray);
    }

    final void decode(ByteArrayBuffer byteArrayBuffer, ByteBuffer byteBuffer) throws HPackException {
        int n2;
        HuffmanNode huffmanNode = this.root;
        int n3 = 0;
        int n4 = 0;
        while (byteBuffer.hasRemaining()) {
            n2 = byteBuffer.get() & 0xFF;
            n3 = n3 << 8 | n2;
            n4 += 8;
            while (n4 >= 8) {
                n2 = n3 >>> n4 - 8 & 0xFF;
                huffmanNode = huffmanNode.getChild(n2);
                n4 -= huffmanNode.getBits();
                if (!huffmanNode.isTerminal()) continue;
                if (huffmanNode.getSymbol() == 256) {
                    throw new HPackException("EOS decoded");
                }
                byteArrayBuffer.append(huffmanNode.getSymbol());
                huffmanNode = this.root;
            }
        }
        while (n4 > 0 && (huffmanNode = huffmanNode.getChild(n2 = n3 << 8 - n4 & 0xFF)).isTerminal() && huffmanNode.getBits() <= n4) {
            n4 -= huffmanNode.getBits();
            byteArrayBuffer.append(huffmanNode.getSymbol());
            huffmanNode = this.root;
        }
        n2 = (1 << n4) - 1;
        if ((n3 & n2) != n2) {
            throw new HPackException("Invalid padding");
        }
    }

    private static HuffmanNode buildTree(int[] nArray, byte[] byArray) {
        HuffmanNode huffmanNode = new HuffmanNode();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            int n3 = byArray[i2];
            HuffmanNode huffmanNode2 = huffmanNode;
            while (n3 > 8) {
                if (huffmanNode2.isTerminal()) {
                    throw new IllegalStateException("Invalid Huffman code: prefix not unique");
                }
                int n4 = n2 >>> (n3 -= 8) & 0xFF;
                if (!huffmanNode2.hasChild(n4)) {
                    huffmanNode2.setChild(n4, new HuffmanNode());
                }
                huffmanNode2 = huffmanNode2.getChild(n4);
            }
            HuffmanNode huffmanNode3 = new HuffmanNode(i2, n3);
            n3 = 8 - n3;
            n2 = n2 << n3 & 0xFF;
            n3 = 1 << n3;
            for (int i3 = n2; i3 < n2 + n3; ++i3) {
                huffmanNode2.setChild(i3, huffmanNode3);
            }
        }
        return huffmanNode;
    }
}

