/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import java.nio.ByteBuffer;
import org.apache.hc.core5.util.ByteArrayBuffer;

final class HuffmanEncoder {
    private final int[] codes;
    private final byte[] lengths;

    HuffmanEncoder(int[] nArray, byte[] byArray) {
        this.codes = nArray;
        this.lengths = byArray;
    }

    final void encode(ByteArrayBuffer byteArrayBuffer, ByteBuffer byteBuffer) {
        long l2 = 0L;
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            int n3 = byteBuffer.get() & 0xFF;
            int n4 = this.codes[n3];
            n3 = this.lengths[n3];
            l2 <<= n3;
            l2 |= (long)n4;
            n2 += n3;
            while (n2 >= 8) {
                byteArrayBuffer.append((int)(l2 >> (n2 -= 8)));
            }
        }
        if (n2 > 0) {
            l2 <<= 8 - n2;
            byteArrayBuffer.append((int)(l2 |= (long)(255 >>> n2)));
        }
    }

    final void encode(ByteArrayBuffer byteArrayBuffer, CharSequence charSequence, int n2, int n3) {
        long l2 = 0L;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = charSequence.charAt(n2 + i2) & 0xFF;
            int n6 = this.codes[n5];
            n5 = this.lengths[n5];
            l2 <<= n5;
            l2 |= (long)n6;
            n4 += n5;
            while (n4 >= 8) {
                byteArrayBuffer.append((int)(l2 >> (n4 -= 8)));
            }
        }
        if (n4 > 0) {
            l2 <<= 8 - n4;
            byteArrayBuffer.append((int)(l2 |= (long)(255 >>> n4)));
        }
    }
}

