/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hc.core5.http2.hpack.HPackEntry;
import org.apache.hc.core5.http2.hpack.HPackHeader;
import org.apache.hc.core5.http2.hpack.StaticTable$InternalEntry;

final class StaticTable {
    static final HPackHeader[] STANDARD_HEADERS = new HPackHeader[]{new HPackHeader(":authority", ""), new HPackHeader(":method", "GET"), new HPackHeader(":method", "POST"), new HPackHeader(":path", "/"), new HPackHeader(":path", "/index.html"), new HPackHeader(":scheme", "http"), new HPackHeader(":scheme", "https"), new HPackHeader(":status", "200"), new HPackHeader(":status", "204"), new HPackHeader(":status", "206"), new HPackHeader(":status", "304"), new HPackHeader(":status", "400"), new HPackHeader(":status", "404"), new HPackHeader(":status", "500"), new HPackHeader("accept-charset", ""), new HPackHeader("accept-encoding", "gzip, deflate"), new HPackHeader("accept-language", ""), new HPackHeader("accept-ranges", ""), new HPackHeader("accept", ""), new HPackHeader("access-control-allow-origin", ""), new HPackHeader("age", ""), new HPackHeader("allow", ""), new HPackHeader("authorization", ""), new HPackHeader("cache-control", ""), new HPackHeader("content-disposition", ""), new HPackHeader("content-encoding", ""), new HPackHeader("content-language", ""), new HPackHeader("content-length", ""), new HPackHeader("content-location", ""), new HPackHeader("content-range", ""), new HPackHeader("content-type", ""), new HPackHeader("cookie", ""), new HPackHeader("date", ""), new HPackHeader("etag", ""), new HPackHeader("expect", ""), new HPackHeader("expires", ""), new HPackHeader("from", ""), new HPackHeader("host", ""), new HPackHeader("if-match", ""), new HPackHeader("if-modified-since", ""), new HPackHeader("if-none-match", ""), new HPackHeader("if-range", ""), new HPackHeader("if-unmodified-since", ""), new HPackHeader("last-modified", ""), new HPackHeader("link", ""), new HPackHeader("location", ""), new HPackHeader("max-forwards", ""), new HPackHeader("proxy-authenticate", ""), new HPackHeader("proxy-authorization", ""), new HPackHeader("range", ""), new HPackHeader("referer", ""), new HPackHeader("refresh", ""), new HPackHeader("retry-after", ""), new HPackHeader("server", ""), new HPackHeader("set-cookie", ""), new HPackHeader("strict-transport-security", ""), new HPackHeader("transfer-encoding", ""), new HPackHeader("user-agent", ""), new HPackHeader("vary", ""), new HPackHeader("via", ""), new HPackHeader("www-authenticate", "")};
    static final StaticTable INSTANCE = new StaticTable(STANDARD_HEADERS);
    private final HPackHeader[] headers;
    private final ConcurrentMap<String, CopyOnWriteArrayList<HPackEntry>> mapByName;

    StaticTable(HPackHeader ... hPackHeaderArray) {
        this.headers = hPackHeaderArray;
        this.mapByName = new ConcurrentHashMap<String, CopyOnWriteArrayList<HPackEntry>>();
        for (int i2 = 0; i2 < hPackHeaderArray.length; ++i2) {
            HPackHeader hPackHeader = hPackHeaderArray[i2];
            String string = hPackHeader.getName();
            CopyOnWriteArrayList<HPackEntry> copyOnWriteArrayList = (CopyOnWriteArrayList<HPackEntry>)this.mapByName.get(string);
            if (copyOnWriteArrayList == null) {
                copyOnWriteArrayList = new CopyOnWriteArrayList<HPackEntry>(new HPackEntry[]{new StaticTable$InternalEntry(hPackHeader, i2)});
                this.mapByName.put(string, copyOnWriteArrayList);
                continue;
            }
            copyOnWriteArrayList.add(new StaticTable$InternalEntry(hPackHeader, i2));
        }
    }

    public final int length() {
        return this.headers.length;
    }

    public final HPackHeader get(int n2) {
        return this.headers[n2 - 1];
    }

    public final List<HPackEntry> getByName(String string) {
        return (List)this.mapByName.get(string);
    }
}

