/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http2.H2MessageConverter;
import org.apache.hc.core5.util.TextUtils;

public class DefaultH2ResponseConverter
implements H2MessageConverter<HttpResponse> {
    public static final DefaultH2ResponseConverter INSTANCE = new DefaultH2ResponseConverter();

    @Override
    public HttpResponse convert(List<Header> list) throws HttpException {
        Object object;
        int n2;
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = list.get(n2);
            String string2 = object.getName();
            String string3 = object.getValue();
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                if (!Character.isAlphabetic(c2) || Character.isLowerCase(c2)) continue;
                throw new ProtocolException("Header name '%s' is invalid (header name contains uppercase characters)", string2);
            }
            if (string2.startsWith(":")) {
                if (!arrayList.isEmpty()) {
                    throw new ProtocolException("Invalid sequence of headers (pseudo-headers must precede message headers)");
                }
                if (string2.equals(":status")) {
                    if (string != null) {
                        throw new ProtocolException("Multiple '%s' response headers are illegal", string2);
                    }
                    string = string3;
                    continue;
                }
                throw new ProtocolException("Unsupported response header '%s'", string2);
            }
            arrayList.add(object);
        }
        if (string == null) {
            throw new ProtocolException("Mandatory response header '%s' not found", ":status");
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Invalid response status: " + string);
        }
        object = new BasicHttpResponse(n2, null);
        object.setVersion(HttpVersion.HTTP_2);
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            object.addHeader((Header)arrayList.get(i3));
        }
        return object;
    }

    @Override
    public List<Header> convert(HttpResponse object) throws HttpException {
        int n2 = object.getCode();
        if (n2 < 100 || n2 >= 600) {
            throw new ProtocolException("Response status %s is invalid", n2);
        }
        ArrayList<Header> arrayList = new ArrayList<Header>();
        arrayList.add(new BasicHeader(":status", Integer.toString(n2), false));
        object = object.headerIterator();
        while (object.hasNext()) {
            Object object2 = (Header)object.next();
            String string = object2.getName();
            object2 = object2.getValue();
            if (string.startsWith(":")) {
                throw new ProtocolException("Header name '%s' is invalid", string);
            }
            arrayList.add(new BasicHeader(TextUtils.toLowerCase(string), object2));
        }
        return arrayList;
    }
}

