/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2CorruptFrameException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2TransportMetrics;
import org.apache.hc.core5.http2.frame.FrameFlag;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.impl.BasicH2TransportMetrics;
import org.apache.hc.core5.util.Args;

public final class FrameInputBuffer {
    private final BasicH2TransportMetrics metrics;
    private final int maxFramePayloadSize;
    private final byte[] buffer;
    private int off;
    private int dataLen;

    FrameInputBuffer(BasicH2TransportMetrics basicH2TransportMetrics, int n2, int n3) {
        Args.notNull(basicH2TransportMetrics, "HTTP2 transport metrics");
        Args.positive(n3, "Maximum payload size");
        this.metrics = basicH2TransportMetrics;
        this.maxFramePayloadSize = n3;
        this.buffer = new byte[n2];
        this.dataLen = 0;
    }

    public FrameInputBuffer(BasicH2TransportMetrics basicH2TransportMetrics, int n2) {
        this(basicH2TransportMetrics, n2 + 9, n2);
    }

    public FrameInputBuffer(int n2) {
        this(new BasicH2TransportMetrics(), n2);
    }

    final boolean hasData() {
        return this.dataLen > 0;
    }

    final void fillBuffer(InputStream inputStream, int n2) throws IOException {
        while (this.dataLen < n2) {
            int n3;
            if (this.off > 0) {
                System.arraycopy(this.buffer, this.off, this.buffer, 0, this.dataLen);
                this.off = 0;
            }
            if ((n3 = inputStream.read(this.buffer, this.off + this.dataLen, this.buffer.length - this.dataLen)) == -1) {
                if (this.dataLen > 0) {
                    throw new H2CorruptFrameException("Corrupt or incomplete HTTP2 frame");
                }
                throw new ConnectionClosedException();
            }
            this.dataLen += n3;
            this.metrics.incrementBytesTransferred(n3);
        }
    }

    public final RawFrame read(InputStream object) throws IOException {
        this.fillBuffer((InputStream)object, 9);
        int n2 = (this.buffer[this.off] & 0xFF) << 16 | (this.buffer[this.off + 1] & 0xFF) << 8 | this.buffer[this.off + 2] & 0xFF;
        int n3 = this.buffer[this.off + 3] & 0xFF;
        int n4 = this.buffer[this.off + 4] & 0xFF;
        int n5 = Math.abs(this.buffer[this.off + 5] & 0xFF) << 24 | this.buffer[this.off + 6] & 0xFF0000 | (this.buffer[this.off + 7] & 0xFF) << 8 | this.buffer[this.off + 8] & 0xFF;
        if (n2 > this.maxFramePayloadSize) {
            throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Frame size exceeds maximum");
        }
        int n6 = n2 + 9;
        this.fillBuffer((InputStream)object, n6);
        if ((n4 & FrameFlag.PADDED.getValue()) > 0) {
            if (n2 == 0) {
                throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Inconsistent padding");
            }
            int n7 = this.buffer[this.off + 9] & 0xFF;
            if (n2 < n7 + 1) {
                throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Inconsistent padding");
            }
        }
        object = n2 > 0 ? ByteBuffer.wrap(this.buffer, this.off + 9, n2) : null;
        object = new RawFrame(n3, n4, n5, (ByteBuffer)object);
        this.off += n6;
        this.dataLen -= n6;
        this.metrics.incrementFramesTransferred();
        return object;
    }

    public final H2TransportMetrics getMetrics() {
        return this.metrics;
    }
}

