/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2TransportMetrics;
import org.apache.hc.core5.http2.frame.Frame;
import org.apache.hc.core5.http2.frame.FrameFlag;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.impl.BasicH2TransportMetrics;
import org.apache.hc.core5.util.Args;

public final class FrameOutputBuffer {
    private final BasicH2TransportMetrics metrics;
    private final int maxFramePayloadSize;
    private final byte[] buffer;

    public FrameOutputBuffer(BasicH2TransportMetrics basicH2TransportMetrics, int n2) {
        Args.notNull(basicH2TransportMetrics, "HTTP2 transport metrics");
        Args.positive(n2, "Maximum payload size");
        this.metrics = basicH2TransportMetrics;
        this.maxFramePayloadSize = n2;
        this.buffer = new byte[n2 + 9 + 255 + 1];
    }

    public FrameOutputBuffer(int n2) {
        this(new BasicH2TransportMetrics(), n2);
    }

    public final void write(RawFrame object, OutputStream outputStream) throws IOException {
        int n2;
        if (object == null) {
            return;
        }
        int n3 = ((Frame)object).getType();
        long l2 = ((Frame)object).getStreamId();
        int n4 = ((Frame)object).getFlags();
        int n5 = n2 = (object = ((RawFrame)object).getPayload()) != null ? ((Buffer)object).remaining() : 0;
        if (object != null && ((Buffer)object).remaining() > this.maxFramePayloadSize) {
            throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Frame size exceeds maximum");
        }
        this.buffer[0] = (byte)(n2 >> 16);
        this.buffer[1] = (byte)(n2 >> 8);
        this.buffer[2] = (byte)n2;
        this.buffer[3] = (byte)n3;
        this.buffer[4] = (byte)n4;
        this.buffer[5] = (byte)(l2 >> 24 & 0xFFL);
        this.buffer[6] = (byte)(l2 >> 16 & 0xFFL);
        this.buffer[7] = (byte)(l2 >> 8 & 0xFFL);
        this.buffer[8] = (byte)(l2 & 0xFFL);
        n3 = 9;
        int n6 = 0;
        if ((n4 & FrameFlag.PADDED.getValue()) > 0) {
            n6 = 16;
            this.buffer[9] = 16;
            ++n3;
        }
        if (object != null) {
            ((ByteBuffer)object).get(this.buffer, n3, ((Buffer)object).remaining());
            n3 += n2;
        }
        for (int i2 = 0; i2 < n6; ++i2) {
            this.buffer[n3++] = 0;
        }
        outputStream.write(this.buffer, 0, n3);
        this.metrics.incrementFramesTransferred();
        this.metrics.incrementBytesTransferred(n3);
    }

    public final H2TransportMetrics getMetrics() {
        return this.metrics;
    }
}

