/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.nio.ByteBuffer;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer$1;
import org.apache.hc.core5.util.ByteArrayBuffer;

class AbstractH2StreamMultiplexer$Continuation {
    final int streamId;
    final int type;
    final boolean endStream;
    final ByteArrayBuffer headerBuffer;
    final int maxContinuation;
    final boolean enforceMacContinuations;
    private int count;

    private AbstractH2StreamMultiplexer$Continuation(int n2, int n3, boolean bl2, int n4) {
        this.streamId = n2;
        this.type = n3;
        this.endStream = bl2;
        this.maxContinuation = n4;
        this.enforceMacContinuations = n4 < Integer.MAX_VALUE;
        this.headerBuffer = new ByteArrayBuffer(1024);
    }

    void copyPayload(ByteBuffer byteBuffer) throws H2ConnectionException {
        if (byteBuffer == null) {
            return;
        }
        if (this.enforceMacContinuations && this.count > this.maxContinuation) {
            throw new H2ConnectionException(H2Error.ENHANCE_YOUR_CALM, "Excessive number of continuation frames");
        }
        ++this.count;
        int n2 = this.headerBuffer.length();
        int n3 = byteBuffer.remaining();
        this.headerBuffer.ensureCapacity(n3);
        byteBuffer.get(this.headerBuffer.array(), n2, n3);
        this.headerBuffer.setLength(n2 + n3);
    }

    ByteBuffer getContent() {
        return ByteBuffer.wrap(this.headerBuffer.array(), 0, this.headerBuffer.length());
    }

    /* synthetic */ AbstractH2StreamMultiplexer$Continuation(int n2, int n3, boolean bl2, int n4, AbstractH2StreamMultiplexer$1 abstractH2StreamMultiplexer$1) {
        this(n2, n3, bl2, n4);
    }
}

