/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.StreamClosedException;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2StreamResetException;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer$1;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer$H2StreamChannelImpl;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;

class AbstractH2StreamMultiplexer$H2Stream {
    private final AbstractH2StreamMultiplexer$H2StreamChannelImpl channel;
    private final H2StreamHandler handler;
    private final boolean remoteInitiated;
    private final AtomicBoolean released;

    private AbstractH2StreamMultiplexer$H2Stream(AbstractH2StreamMultiplexer$H2StreamChannelImpl h2StreamChannelImpl, H2StreamHandler h2StreamHandler, boolean bl2) {
        this.channel = h2StreamChannelImpl;
        this.handler = h2StreamHandler;
        this.remoteInitiated = bl2;
        this.released = new AtomicBoolean();
    }

    int getId() {
        return this.channel.getId();
    }

    boolean isRemoteInitiated() {
        return this.remoteInitiated;
    }

    AtomicInteger getOutputWindow() {
        return this.channel.getOutputWindow();
    }

    AtomicInteger getInputWindow() {
        return this.channel.getInputWindow();
    }

    boolean isTerminated() {
        return this.channel.isLocalClosed() && (this.channel.isRemoteClosed() || this.channel.isResetDeadline());
    }

    boolean isRemoteClosed() {
        return this.channel.isRemoteClosed();
    }

    boolean isLocalClosed() {
        return this.channel.isLocalClosed();
    }

    boolean isLocalReset() {
        return this.channel.isLocalReset();
    }

    void setRemoteEndStream() {
        this.channel.setRemoteEndStream();
    }

    void consumePromise(List<Header> list) throws HttpException, IOException {
        try {
            this.handler.consumePromise(list);
            this.channel.setLocalEndStream();
            return;
        }
        catch (ProtocolException protocolException) {
            this.localReset((Exception)protocolException, H2Error.PROTOCOL_ERROR);
            return;
        }
    }

    void consumeHeader(List<Header> list) throws HttpException, IOException {
        try {
            this.handler.consumeHeader(list, this.channel.isRemoteClosed());
            return;
        }
        catch (ProtocolException protocolException) {
            this.localReset((Exception)protocolException, H2Error.PROTOCOL_ERROR);
            return;
        }
    }

    void consumeData(ByteBuffer byteBuffer) throws HttpException, IOException {
        try {
            this.handler.consumeData(byteBuffer, this.channel.isRemoteClosed());
            return;
        }
        catch (CharacterCodingException characterCodingException) {
            this.localReset((Exception)characterCodingException, H2Error.INTERNAL_ERROR);
            return;
        }
        catch (ProtocolException protocolException) {
            this.localReset((Exception)protocolException, H2Error.PROTOCOL_ERROR);
            return;
        }
    }

    boolean isOutputReady() {
        return this.handler.isOutputReady();
    }

    void produceOutput() throws HttpException, IOException {
        try {
            this.handler.produceOutput();
            return;
        }
        catch (ProtocolException protocolException) {
            this.localReset((Exception)protocolException, H2Error.PROTOCOL_ERROR);
            return;
        }
    }

    void produceInputCapacityUpdate() throws IOException {
        this.handler.updateInputCapacity();
    }

    void fail(Exception exception) {
        this.channel.setRemoteEndStream();
        this.channel.setLocalEndStream();
        if (this.released.compareAndSet(false, true)) {
            this.handler.failed(exception);
            this.handler.releaseResources();
        }
    }

    void localReset(Exception exception, int n2) throws IOException {
        this.channel.localReset(n2);
        if (this.released.compareAndSet(false, true)) {
            this.handler.failed(exception);
            this.handler.releaseResources();
        }
    }

    void localReset(Exception exception, H2Error h2Error) throws IOException {
        this.localReset(exception, h2Error != null ? h2Error.getCode() : H2Error.INTERNAL_ERROR.getCode());
    }

    void localReset(H2StreamResetException h2StreamResetException) throws IOException {
        H2StreamResetException h2StreamResetException2 = h2StreamResetException;
        this.localReset((Exception)h2StreamResetException2, h2StreamResetException2.getCode());
    }

    void handle(HttpException httpException) throws IOException, HttpException {
        this.handler.handle(httpException, this.channel.isRemoteClosed());
    }

    HandlerFactory<AsyncPushConsumer> getPushHandlerFactory() {
        return this.handler.getPushHandlerFactory();
    }

    boolean abort() {
        boolean bl2 = this.channel.cancel();
        if (this.released.compareAndSet(false, true)) {
            this.handler.failed(new StreamClosedException());
            this.handler.releaseResources();
        }
        return bl2;
    }

    void releaseResources() {
        if (this.released.compareAndSet(false, true)) {
            this.handler.releaseResources();
        }
    }

    void appendState(StringBuilder stringBuilder) {
        stringBuilder.append("channel=[");
        this.channel.appendState(stringBuilder);
        stringBuilder.append("]");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        this.appendState(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /* synthetic */ AbstractH2StreamMultiplexer$H2Stream(AbstractH2StreamMultiplexer$H2StreamChannelImpl h2StreamChannelImpl, H2StreamHandler h2StreamHandler, boolean bl2, AbstractH2StreamMultiplexer$1 abstractH2StreamMultiplexer$1) {
        this(h2StreamChannelImpl, h2StreamHandler, bl2);
    }
}

