/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer$H2Stream;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.ServerPushH2StreamHandler;

class AbstractH2StreamMultiplexer$H2StreamChannelImpl
implements H2StreamChannel {
    private final int id;
    private final AtomicInteger inputWindow;
    private final AtomicInteger outputWindow;
    private volatile boolean idle;
    private volatile boolean remoteEndStream;
    private volatile boolean localEndStream;
    private volatile long deadline;
    final /* synthetic */ AbstractH2StreamMultiplexer this$0;

    AbstractH2StreamMultiplexer$H2StreamChannelImpl(AbstractH2StreamMultiplexer abstractH2StreamMultiplexer, int n2, boolean bl2, int n3, int n4) {
        this.this$0 = abstractH2StreamMultiplexer;
        this.id = n2;
        this.idle = bl2;
        this.inputWindow = new AtomicInteger(n3);
        this.outputWindow = new AtomicInteger(n4);
    }

    int getId() {
        return this.id;
    }

    AtomicInteger getOutputWindow() {
        return this.outputWindow;
    }

    AtomicInteger getInputWindow() {
        return this.inputWindow;
    }

    @Override
    public void submit(List<Header> list, boolean bl2) throws IOException {
        AbstractH2StreamMultiplexer.access$200(this.this$0).getLock().lock();
        try {
            if (list == null || list.isEmpty()) {
                throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Message headers are missing");
            }
            if (this.localEndStream) {
                return;
            }
            this.idle = false;
            AbstractH2StreamMultiplexer.access$300(this.this$0, this.id, list, bl2);
            if (bl2) {
                this.localEndStream = true;
            }
            return;
        }
        finally {
            AbstractH2StreamMultiplexer.access$200(this.this$0).getLock().unlock();
        }
    }

    @Override
    public void push(List<Header> list, AsyncPushProducer object) throws HttpException, IOException {
        this.this$0.acceptPushRequest();
        int n2 = AbstractH2StreamMultiplexer.access$400(this.this$0);
        AbstractH2StreamMultiplexer$H2StreamChannelImpl abstractH2StreamMultiplexer$H2StreamChannelImpl = new AbstractH2StreamMultiplexer$H2StreamChannelImpl(this.this$0, n2, true, AbstractH2StreamMultiplexer.access$500(this.this$0).getInitialWindowSize(), AbstractH2StreamMultiplexer.access$600(this.this$0).getInitialWindowSize());
        HttpCoreContext httpCoreContext = HttpCoreContext.create();
        httpCoreContext.setSSLSession(this.this$0.getSSLSession());
        httpCoreContext.setEndpointDetails(this.this$0.getEndpointDetails());
        object = new ServerPushH2StreamHandler(abstractH2StreamMultiplexer$H2StreamChannelImpl, AbstractH2StreamMultiplexer.access$700(this.this$0), AbstractH2StreamMultiplexer.access$800(this.this$0), (AsyncPushProducer)object, httpCoreContext);
        object = new AbstractH2StreamMultiplexer$H2Stream(abstractH2StreamMultiplexer$H2StreamChannelImpl, (H2StreamHandler)object, false, null);
        AbstractH2StreamMultiplexer.access$900(this.this$0).put(n2, object);
        AbstractH2StreamMultiplexer.access$200(this.this$0).getLock().lock();
        try {
            if (this.localEndStream) {
                ((AbstractH2StreamMultiplexer$H2Stream)object).releaseResources();
                return;
            }
            AbstractH2StreamMultiplexer.access$1000(this.this$0, this.id, n2, list);
            this.idle = false;
            return;
        }
        finally {
            AbstractH2StreamMultiplexer.access$200(this.this$0).getLock().unlock();
        }
    }

    @Override
    public void update(int n2) throws IOException {
        if (this.remoteEndStream) {
            return;
        }
        AbstractH2StreamMultiplexer.access$1100(this.this$0, this.id, this.inputWindow, n2);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        AbstractH2StreamMultiplexer.access$200(this.this$0).getLock().lock();
        try {
            if (this.localEndStream) {
                return 0;
            }
            int n2 = AbstractH2StreamMultiplexer.access$1200(this.this$0, this.id, this.outputWindow, byteBuffer);
            return n2;
        }
        finally {
            AbstractH2StreamMultiplexer.access$200(this.this$0).getLock().unlock();
        }
    }

    @Override
    public void endStream(List<? extends Header> object) throws IOException {
        AbstractH2StreamMultiplexer.access$200(this.this$0).getLock().lock();
        try {
            if (this.localEndStream) {
                return;
            }
            this.localEndStream = true;
            if (object != null && !object.isEmpty()) {
                AbstractH2StreamMultiplexer.access$300(this.this$0, this.id, object, true);
            } else {
                object = AbstractH2StreamMultiplexer.access$1300(this.this$0).createData(this.id, null, true);
                AbstractH2StreamMultiplexer.access$1400(this.this$0, (RawFrame)object);
            }
            return;
        }
        finally {
            AbstractH2StreamMultiplexer.access$200(this.this$0).getLock().unlock();
        }
    }

    @Override
    public void endStream() throws IOException {
        this.endStream(null);
    }

    @Override
    public void requestOutput() {
        AbstractH2StreamMultiplexer.access$1500(this.this$0);
    }

    boolean isRemoteClosed() {
        return this.remoteEndStream;
    }

    void setRemoteEndStream() {
        this.remoteEndStream = true;
    }

    boolean isLocalClosed() {
        return this.localEndStream;
    }

    void setLocalEndStream() {
        this.localEndStream = true;
    }

    boolean isLocalReset() {
        return this.deadline > 0L;
    }

    boolean isResetDeadline() {
        long l2 = this.deadline;
        return l2 > 0L && l2 < System.currentTimeMillis();
    }

    boolean localReset(int n2) throws IOException {
        AbstractH2StreamMultiplexer.access$200(this.this$0).getLock().lock();
        try {
            if (this.localEndStream) {
                return false;
            }
            this.localEndStream = true;
            this.deadline = System.currentTimeMillis() + 1000L;
            if (!this.idle) {
                RawFrame rawFrame = AbstractH2StreamMultiplexer.access$1300(this.this$0).createResetStream(this.id, n2);
                AbstractH2StreamMultiplexer.access$1400(this.this$0, rawFrame);
                return true;
            }
            return false;
        }
        finally {
            AbstractH2StreamMultiplexer.access$200(this.this$0).getLock().unlock();
        }
    }

    boolean localReset(H2Error h2Error) throws IOException {
        return this.localReset(h2Error != null ? h2Error.getCode() : H2Error.INTERNAL_ERROR.getCode());
    }

    @Override
    public boolean cancel() {
        try {
            return this.localReset(H2Error.CANCEL);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    void appendState(StringBuilder stringBuilder) {
        stringBuilder.append("id=").append(this.id).append(", connState=").append((Object)AbstractH2StreamMultiplexer.access$1600(this.this$0)).append(", inputWindow=").append(this.inputWindow).append(", outputWindow=").append(this.outputWindow).append(", localEndStream=").append(this.localEndStream).append(", idle=").append(this.idle);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        this.appendState(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

