/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.ExecutableCommand;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.frame.DefaultFrameFactory;
import org.apache.hc.core5.http2.frame.FrameFactory;
import org.apache.hc.core5.http2.frame.StreamIdGenerator;
import org.apache.hc.core5.http2.impl.nio.AbstractH2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.ClientPushH2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.reactor.ProtocolIOSession;

@Internal
public class ClientH2StreamMultiplexer
extends AbstractH2StreamMultiplexer {
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;

    public ClientH2StreamMultiplexer(ProtocolIOSession protocolIOSession, FrameFactory frameFactory, HttpProcessor httpProcessor, HandlerFactory<AsyncPushConsumer> handlerFactory, H2Config h2Config, CharCodingConfig charCodingConfig, H2StreamListener h2StreamListener) {
        super(protocolIOSession, frameFactory, StreamIdGenerator.ODD, httpProcessor, charCodingConfig, h2Config, h2StreamListener);
        this.pushHandlerFactory = handlerFactory;
    }

    public ClientH2StreamMultiplexer(ProtocolIOSession protocolIOSession, HttpProcessor httpProcessor, HandlerFactory<AsyncPushConsumer> handlerFactory, H2Config h2Config, CharCodingConfig charCodingConfig) {
        this(protocolIOSession, DefaultFrameFactory.INSTANCE, httpProcessor, handlerFactory, h2Config, charCodingConfig, null);
    }

    public ClientH2StreamMultiplexer(ProtocolIOSession protocolIOSession, HttpProcessor httpProcessor, H2Config h2Config, CharCodingConfig charCodingConfig) {
        this(protocolIOSession, httpProcessor, null, h2Config, charCodingConfig);
    }

    @Override
    void acceptHeaderFrame() throws H2ConnectionException {
        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal HEADERS frame");
    }

    @Override
    void acceptPushFrame() throws H2ConnectionException {
    }

    @Override
    void acceptPushRequest() throws H2ConnectionException {
        throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Illegal attempt to push a response");
    }

    @Override
    H2StreamHandler createLocallyInitiatedStream(ExecutableCommand object, H2StreamChannel h2StreamChannel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics basicHttpConnectionMetrics) throws IOException {
        if (object instanceof RequestExecutionCommand) {
            object = (RequestExecutionCommand)object;
            AsyncClientExchangeHandler asyncClientExchangeHandler = ((RequestExecutionCommand)object).getExchangeHandler();
            HandlerFactory<AsyncPushConsumer> handlerFactory = ((RequestExecutionCommand)object).getPushHandlerFactory();
            object = HttpCoreContext.castOrCreate(((RequestExecutionCommand)object).getContext());
            ((HttpCoreContext)object).setSSLSession(this.getSSLSession());
            ((HttpCoreContext)object).setEndpointDetails(this.getEndpointDetails());
            return new ClientH2StreamHandler(h2StreamChannel, httpProcessor, basicHttpConnectionMetrics, asyncClientExchangeHandler, handlerFactory != null ? handlerFactory : this.pushHandlerFactory, (HttpCoreContext)object);
        }
        throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Unexpected executable command");
    }

    @Override
    H2StreamHandler createRemotelyInitiatedStream(H2StreamChannel h2StreamChannel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics basicHttpConnectionMetrics, HandlerFactory<AsyncPushConsumer> handlerFactory) throws IOException {
        HttpCoreContext httpCoreContext = HttpCoreContext.create();
        httpCoreContext.setSSLSession(this.getSSLSession());
        httpCoreContext.setEndpointDetails(this.getEndpointDetails());
        return new ClientPushH2StreamHandler(h2StreamChannel, httpProcessor, basicHttpConnectionMetrics, handlerFactory != null ? handlerFactory : this.pushHandlerFactory, httpCoreContext);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        this.appendState(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

