/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.IncomingEntityDetails;
import org.apache.hc.core5.http.impl.nio.MessageState;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2StreamResetException;
import org.apache.hc.core5.http2.impl.DefaultH2RequestConverter;
import org.apache.hc.core5.http2.impl.DefaultH2ResponseConverter;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.NoopAsyncPushHandler;
import org.apache.hc.core5.util.Asserts;

class ClientPushH2StreamHandler
implements H2StreamHandler {
    private final H2StreamChannel internalOutputChannel;
    private final HttpProcessor httpProcessor;
    private final BasicHttpConnectionMetrics connMetrics;
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;
    private final HttpCoreContext context;
    private final AtomicBoolean failed;
    private final AtomicBoolean done;
    private volatile HttpRequest request;
    private volatile AsyncPushConsumer exchangeHandler;
    private volatile MessageState requestState;
    private volatile MessageState responseState;

    ClientPushH2StreamHandler(H2StreamChannel h2StreamChannel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics basicHttpConnectionMetrics, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpCoreContext httpCoreContext) {
        this.internalOutputChannel = h2StreamChannel;
        this.httpProcessor = httpProcessor;
        this.connMetrics = basicHttpConnectionMetrics;
        this.pushHandlerFactory = handlerFactory;
        this.context = httpCoreContext;
        this.failed = new AtomicBoolean();
        this.done = new AtomicBoolean();
        this.requestState = MessageState.HEADERS;
        this.responseState = MessageState.HEADERS;
    }

    @Override
    public HandlerFactory<AsyncPushConsumer> getPushHandlerFactory() {
        return this.pushHandlerFactory;
    }

    @Override
    public boolean isOutputReady() {
        return false;
    }

    @Override
    public void produceOutput() throws HttpException, IOException {
    }

    @Override
    public void consumePromise(List<Header> list) throws HttpException, IOException {
        if (this.requestState == MessageState.HEADERS) {
            this.request = DefaultH2RequestConverter.INSTANCE.convert((List)list);
            try {
                this.exchangeHandler = this.pushHandlerFactory != null ? this.pushHandlerFactory.create(this.request, this.context) : null;
            }
            catch (ProtocolException protocolException) {
                this.exchangeHandler = new NoopAsyncPushHandler();
                throw new H2StreamResetException(H2Error.PROTOCOL_ERROR, protocolException.getMessage());
            }
            if (this.exchangeHandler == null) {
                this.exchangeHandler = new NoopAsyncPushHandler();
                throw new H2StreamResetException(H2Error.REFUSED_STREAM, "Stream refused");
            }
            this.context.setProtocolVersion(HttpVersion.HTTP_2);
            this.context.setRequest(this.request);
            this.httpProcessor.process(this.request, null, (HttpContext)this.context);
            this.connMetrics.incrementRequestCount();
            this.requestState = MessageState.COMPLETE;
            return;
        }
        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected promise");
    }

    @Override
    public void consumeHeader(List<Header> object, boolean bl2) throws HttpException, IOException {
        if (this.responseState == MessageState.HEADERS) {
            Asserts.notNull(this.request, "Request");
            Asserts.notNull(this.exchangeHandler, "Exchange handler");
            object = DefaultH2ResponseConverter.INSTANCE.convert((List)object);
            IncomingEntityDetails incomingEntityDetails = bl2 ? null : new IncomingEntityDetails(this.request, -1L);
            this.context.setResponse((HttpResponse)object);
            this.httpProcessor.process((HttpResponse)object, (EntityDetails)incomingEntityDetails, (HttpContext)this.context);
            this.connMetrics.incrementResponseCount();
            this.exchangeHandler.consumePromise(this.request, (HttpResponse)object, incomingEntityDetails, this.context);
            if (!bl2) {
                this.responseState = MessageState.BODY;
                return;
            }
        } else {
            throw new ProtocolException("Unexpected message headers");
        }
        this.responseState = MessageState.COMPLETE;
        this.exchangeHandler.streamEnd(null);
    }

    @Override
    public void updateInputCapacity() throws IOException {
        Asserts.notNull(this.exchangeHandler, "Exchange handler");
        this.exchangeHandler.updateCapacity(this.internalOutputChannel);
    }

    @Override
    public void consumeData(ByteBuffer byteBuffer, boolean bl2) throws HttpException, IOException {
        if (this.responseState != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        Asserts.notNull(this.exchangeHandler, "Exchange handler");
        if (byteBuffer != null) {
            this.exchangeHandler.consume(byteBuffer);
        }
        if (bl2) {
            this.responseState = MessageState.COMPLETE;
            this.exchangeHandler.streamEnd(null);
        }
    }

    public boolean isDone() {
        return this.responseState == MessageState.COMPLETE;
    }

    @Override
    public void failed(Exception exception) {
        try {
            if (this.failed.compareAndSet(false, true) && this.exchangeHandler != null) {
                this.exchangeHandler.failed(exception);
            }
            return;
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public void handle(HttpException httpException, boolean bl2) throws HttpException {
        throw httpException;
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.responseState = MessageState.COMPLETE;
            this.requestState = MessageState.COMPLETE;
            if (this.exchangeHandler != null) {
                this.exchangeHandler.releaseResources();
            }
        }
    }

    public String toString() {
        return "[requestState=" + (Object)((Object)this.requestState) + ", responseState=" + (Object)((Object)this.responseState) + ']';
    }
}

