/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2CorruptFrameException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2TransportMetrics;
import org.apache.hc.core5.http2.frame.FrameFlag;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.impl.BasicH2TransportMetrics;
import org.apache.hc.core5.http2.impl.nio.FrameInputBuffer$State;
import org.apache.hc.core5.util.Args;

public final class FrameInputBuffer {
    private final BasicH2TransportMetrics metrics;
    private final int maxFramePayloadSize;
    private final byte[] bytes;
    private final ByteBuffer buffer;
    private FrameInputBuffer$State state;
    private int payloadLen;
    private int type;
    private int flags;
    private int streamId;
    private boolean endOfStream;

    FrameInputBuffer(BasicH2TransportMetrics basicH2TransportMetrics, int n2, int n3) {
        Args.notNull(basicH2TransportMetrics, "HTTP2 transport metrics");
        Args.positive(n3, "Maximum payload size");
        this.metrics = basicH2TransportMetrics;
        this.maxFramePayloadSize = Math.max(n3, 16384);
        this.bytes = new byte[n2];
        this.buffer = ByteBuffer.wrap(this.bytes);
        this.buffer.flip();
        this.state = FrameInputBuffer$State.HEAD_EXPECTED;
        this.endOfStream = false;
    }

    public FrameInputBuffer(BasicH2TransportMetrics basicH2TransportMetrics, int n2) {
        this(basicH2TransportMetrics, n2 + 9, n2);
    }

    public FrameInputBuffer(int n2) {
        this(new BasicH2TransportMetrics(), n2);
    }

    @Deprecated
    public final void put(ByteBuffer byteBuffer) {
        if (this.buffer.hasRemaining()) {
            this.buffer.compact();
        } else {
            this.buffer.clear();
        }
        this.buffer.put(byteBuffer);
        this.buffer.flip();
    }

    public final RawFrame read(ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel) throws IOException {
        block18: {
            int n2;
            do {
                if (byteBuffer != null) {
                    if (this.buffer.hasRemaining()) {
                        this.buffer.compact();
                    } else {
                        this.buffer.clear();
                    }
                    n2 = this.buffer.remaining();
                    int n3 = byteBuffer.remaining();
                    if (n2 >= n3) {
                        this.buffer.put(byteBuffer);
                        this.metrics.incrementBytesTransferred(n3);
                    } else {
                        n3 = byteBuffer.limit();
                        byteBuffer.limit(n2);
                        this.buffer.put(byteBuffer);
                        byteBuffer.limit(n3);
                        this.metrics.incrementBytesTransferred(n2);
                    }
                    this.buffer.flip();
                }
                switch (this.state) {
                    case HEAD_EXPECTED: {
                        if (this.buffer.remaining() < 9) break;
                        n2 = this.buffer.getInt();
                        this.payloadLen = n2 >> 8;
                        if (this.payloadLen > this.maxFramePayloadSize) {
                            throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Frame size exceeds maximum");
                        }
                        this.type = n2 & 0xFF;
                        this.flags = this.buffer.get();
                        this.streamId = Math.abs(this.buffer.getInt());
                        this.state = FrameInputBuffer$State.PAYLOAD_EXPECTED;
                    }
                    case PAYLOAD_EXPECTED: {
                        if (this.buffer.remaining() < this.payloadLen) break;
                        if ((this.flags & FrameFlag.PADDED.getValue()) > 0) {
                            if (this.payloadLen == 0) {
                                throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Inconsistent padding");
                            }
                            this.buffer.mark();
                            n2 = this.buffer.get();
                            if (this.payloadLen < n2 + 1) {
                                throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Inconsistent padding");
                            }
                            this.buffer.reset();
                        }
                        ByteBuffer byteBuffer2 = this.payloadLen > 0 ? ByteBuffer.wrap(this.bytes, this.buffer.position(), this.payloadLen) : null;
                        this.buffer.position(this.buffer.position() + this.payloadLen);
                        this.state = FrameInputBuffer$State.HEAD_EXPECTED;
                        this.metrics.incrementFramesTransferred();
                        return new RawFrame(this.type, this.flags, this.streamId, byteBuffer2);
                    }
                }
                if (this.buffer.hasRemaining()) {
                    this.buffer.compact();
                } else {
                    this.buffer.clear();
                }
                n2 = readableByteChannel.read(this.buffer);
                this.buffer.flip();
                if (n2 > 0) {
                    this.metrics.incrementBytesTransferred(n2);
                }
                if (n2 == 0) break block18;
            } while (n2 != -1);
            if (this.state != FrameInputBuffer$State.HEAD_EXPECTED || this.buffer.hasRemaining()) {
                throw new H2CorruptFrameException("Corrupt or incomplete HTTP2 frame");
            }
            this.endOfStream = true;
        }
        return null;
    }

    public final RawFrame read(ReadableByteChannel readableByteChannel) throws IOException {
        return this.read(null, readableByteChannel);
    }

    public final void reset() {
        this.buffer.compact();
        this.state = FrameInputBuffer$State.HEAD_EXPECTED;
        this.endOfStream = false;
    }

    public final H2TransportMetrics getMetrics() {
        return this.metrics;
    }

    @Internal
    public final boolean isEndOfStream() {
        return this.endOfStream;
    }
}

