/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hc.core5.http2.H2TransportMetrics;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.impl.BasicH2TransportMetrics;
import org.apache.hc.core5.util.Args;

public final class FrameOutputBuffer {
    private final BasicH2TransportMetrics metrics;
    private int maxFramePayloadSize;
    private ByteBuffer buffer;

    public FrameOutputBuffer(BasicH2TransportMetrics basicH2TransportMetrics, int n2) {
        Args.notNull(basicH2TransportMetrics, "HTTP2 transport metrics");
        Args.positive(n2, "Maximum payload size");
        this.metrics = basicH2TransportMetrics;
        this.maxFramePayloadSize = n2;
        this.buffer = ByteBuffer.allocate(n2 + 9);
    }

    public FrameOutputBuffer(int n2) {
        this(new BasicH2TransportMetrics(), n2);
    }

    @Deprecated
    public final void expand(int n2) {
        this.resize(n2);
    }

    public final int getMaxFramePayloadSize() {
        return this.maxFramePayloadSize;
    }

    public final void resize(int n2) {
        if (this.buffer.capacity() == n2) {
            return;
        }
        this.maxFramePayloadSize = n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 + 9);
        if (this.buffer.position() > 0) {
            this.buffer.flip();
            byteBuffer.put(this.buffer);
        }
        this.buffer = byteBuffer;
    }

    public final void write(RawFrame rawFrame, WritableByteChannel writableByteChannel) throws IOException {
        Args.notNull(rawFrame, "Frame");
        ByteBuffer byteBuffer = rawFrame.getPayload();
        Args.check(byteBuffer == null || byteBuffer.remaining() <= this.maxFramePayloadSize, "Frame size exceeds maximum");
        this.buffer.putInt((byteBuffer != null ? byteBuffer.remaining() << 8 : 0) | rawFrame.getType() & 0xFF);
        this.buffer.put((byte)rawFrame.getFlags());
        this.buffer.putInt(rawFrame.getStreamId());
        if (byteBuffer != null) {
            if (writableByteChannel instanceof GatheringByteChannel) {
                this.buffer.flip();
                ((GatheringByteChannel)writableByteChannel).write(new ByteBuffer[]{this.buffer, byteBuffer});
                this.buffer.compact();
                if (byteBuffer.hasRemaining()) {
                    this.buffer.put(byteBuffer);
                }
            } else {
                this.buffer.put(byteBuffer);
            }
        }
        this.flush(writableByteChannel);
        this.metrics.incrementFramesTransferred();
    }

    public final void flush(WritableByteChannel writableByteChannel) throws IOException {
        if (this.buffer.position() > 0) {
            this.buffer.flip();
            try {
                int n2 = writableByteChannel.write(this.buffer);
                if (n2 > 0) {
                    this.metrics.incrementBytesTransferred(n2);
                }
                return;
            }
            finally {
                this.buffer.compact();
            }
        }
    }

    public final boolean isEmpty() {
        return this.buffer.position() == 0;
    }

    public final H2TransportMetrics getMetrics() {
        return this.metrics;
    }
}

