/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.command.CommandSupport;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

abstract class PrefaceHandlerBase
implements HttpConnectionEventHandler {
    final ProtocolIOSession ioSession;
    private final AtomicReference<HttpConnectionEventHandler> protocolHandlerRef;
    private final FutureCallback<ProtocolIOSession> resultCallback;
    private final Callback<Exception> exceptionCallback;
    private final AtomicBoolean completed;

    PrefaceHandlerBase(ProtocolIOSession protocolIOSession, FutureCallback<ProtocolIOSession> futureCallback, Callback<Exception> callback) {
        this.ioSession = Args.notNull(protocolIOSession, "I/O session");
        this.protocolHandlerRef = new AtomicReference();
        this.resultCallback = futureCallback;
        this.exceptionCallback = callback;
        this.completed = new AtomicBoolean();
    }

    void startProtocol(HttpConnectionEventHandler httpConnectionEventHandler, ByteBuffer byteBuffer) throws IOException {
        this.protocolHandlerRef.set(httpConnectionEventHandler);
        this.ioSession.upgrade(httpConnectionEventHandler);
        httpConnectionEventHandler.connected(this.ioSession);
        if (byteBuffer != null && byteBuffer.hasRemaining()) {
            httpConnectionEventHandler.inputReady(this.ioSession, byteBuffer);
        }
        if (this.completed.compareAndSet(false, true) && this.resultCallback != null) {
            this.resultCallback.completed(this.ioSession);
        }
    }

    @Override
    public void timeout(IOSession iOSession, Timeout timeout) {
        this.exception(iOSession, SocketTimeoutExceptionFactory.create(timeout));
    }

    @Override
    public void exception(IOSession iOSession, Exception exception) {
        block5: {
            HttpConnectionEventHandler httpConnectionEventHandler = this.protocolHandlerRef.get();
            try {
                iOSession.close(CloseMode.IMMEDIATE);
                if (httpConnectionEventHandler == null) {
                    CommandSupport.failCommands(iOSession, exception);
                    if (this.exceptionCallback != null) {
                        this.exceptionCallback.execute(exception);
                    }
                    return;
                }
                httpConnectionEventHandler.exception(iOSession, exception);
            }
            catch (Exception exception2) {
                if (this.completed.compareAndSet(false, true) && this.resultCallback != null) {
                    this.resultCallback.failed(exception2);
                }
                if (this.exceptionCallback == null) break block5;
                this.exceptionCallback.execute(exception);
            }
        }
    }

    @Override
    public void disconnected(IOSession iOSession) {
        HttpConnectionEventHandler httpConnectionEventHandler = this.protocolHandlerRef.getAndSet(null);
        try {
            if (httpConnectionEventHandler != null) {
                httpConnectionEventHandler.disconnected(this.ioSession);
            } else {
                CommandSupport.cancelCommands(iOSession);
            }
            if (this.completed.compareAndSet(false, true) && this.resultCallback != null) {
                this.resultCallback.failed(new ConnectionClosedException());
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.completed.compareAndSet(false, true) && this.resultCallback != null) {
                this.resultCallback.failed(new ConnectionClosedException());
            }
            throw throwable;
        }
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        if (tlsDetails != null) {
            return tlsDetails.getSSLSession();
        }
        return null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return null;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return this.ioSession.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.ioSession.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }
}

