/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.impl.nio.BufferedData;
import org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import org.apache.hc.core5.http2.impl.nio.PrefaceHandlerBase;
import org.apache.hc.core5.http2.impl.nio.ProtocolNegotiationException;
import org.apache.hc.core5.http2.impl.nio.ServerH2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;

@Internal
public class ServerH2PrefaceHandler
extends PrefaceHandlerBase {
    static final byte[] PREFACE = ClientH2PrefaceHandler.PREFACE;
    private final ServerH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final BufferedData inBuf;

    public ServerH2PrefaceHandler(ProtocolIOSession protocolIOSession, ServerH2StreamMultiplexerFactory serverH2StreamMultiplexerFactory, Callback<Exception> callback) {
        this(protocolIOSession, serverH2StreamMultiplexerFactory, null, callback);
    }

    public ServerH2PrefaceHandler(ProtocolIOSession protocolIOSession, ServerH2StreamMultiplexerFactory serverH2StreamMultiplexerFactory, FutureCallback<ProtocolIOSession> futureCallback, Callback<Exception> callback) {
        super(protocolIOSession, futureCallback, callback);
        this.http2StreamHandlerFactory = Args.notNull(serverH2StreamMultiplexerFactory, "HTTP/2 stream handler factory");
        this.inBuf = BufferedData.allocate(1024);
    }

    @Override
    public void connected(IOSession iOSession) throws IOException {
    }

    @Override
    public void inputReady(IOSession object, ByteBuffer byteBuffer) throws IOException {
        int n2;
        if (byteBuffer != null) {
            this.inBuf.put(byteBuffer);
        }
        int n3 = 0;
        if (this.inBuf.length() < PREFACE.length && (n2 = this.inBuf.readFrom((ReadableByteChannel)object)) == -1) {
            n3 = 1;
        }
        if (((Buffer)(object = this.inBuf.data())).remaining() >= PREFACE.length) {
            for (n3 = 0; n3 < PREFACE.length; ++n3) {
                if (((ByteBuffer)object).get() == PREFACE[n3]) continue;
                throw new ProtocolNegotiationException("Unexpected HTTP/2 preface");
            }
            this.startProtocol(new ServerH2IOEventHandler(this.http2StreamHandlerFactory.create(this.ioSession)), (ByteBuffer)(((Buffer)object).hasRemaining() ? object : null));
            return;
        }
        if (n3 != 0) {
            throw new ConnectionClosedException();
        }
    }

    @Override
    public void outputReady(IOSession iOSession) throws IOException {
    }

    public String toString() {
        return this.getClass().getName();
    }
}

