/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.IncomingEntityDetails;
import org.apache.hc.core5.http.impl.ServerSupport;
import org.apache.hc.core5.http.impl.nio.MessageState;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.support.BasicResponseProducer;
import org.apache.hc.core5.http.nio.support.ImmediateResponseExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2StreamResetException;
import org.apache.hc.core5.http2.impl.DefaultH2RequestConverter;
import org.apache.hc.core5.http2.impl.DefaultH2ResponseConverter;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.ServerH2StreamHandler$1;
import org.apache.hc.core5.http2.impl.nio.ServerH2StreamHandler$2;
import org.apache.hc.core5.util.Asserts;

class ServerH2StreamHandler
implements H2StreamHandler {
    private final H2StreamChannel outputChannel;
    private final DataStreamChannel dataChannel;
    private final ResponseChannel responseChannel;
    private final HttpProcessor httpProcessor;
    private final BasicHttpConnectionMetrics connMetrics;
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;
    private final HttpCoreContext context;
    private final AtomicReference<MessageState> requestState;
    private final AtomicReference<MessageState> responseState;
    private final AtomicBoolean responseCommitted;
    private final AtomicBoolean failed;
    private final AtomicBoolean done;
    private volatile AsyncServerExchangeHandler exchangeHandler;
    private volatile HttpRequest receivedRequest;

    ServerH2StreamHandler(H2StreamChannel h2StreamChannel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics basicHttpConnectionMetrics, HandlerFactory<AsyncServerExchangeHandler> handlerFactory, HttpCoreContext httpCoreContext) {
        this.outputChannel = h2StreamChannel;
        this.dataChannel = new ServerH2StreamHandler$1(this, h2StreamChannel);
        this.responseChannel = new ServerH2StreamHandler$2(this);
        this.httpProcessor = httpProcessor;
        this.connMetrics = basicHttpConnectionMetrics;
        this.exchangeHandlerFactory = handlerFactory;
        this.context = httpCoreContext;
        this.responseCommitted = new AtomicBoolean();
        this.failed = new AtomicBoolean();
        this.done = new AtomicBoolean();
        this.requestState = new AtomicReference<MessageState>(MessageState.HEADERS);
        this.responseState = new AtomicReference<MessageState>(MessageState.IDLE);
    }

    @Override
    public HandlerFactory<AsyncPushConsumer> getPushHandlerFactory() {
        return null;
    }

    private void commitInformation(HttpResponse object) throws IOException, HttpException {
        if (this.responseCommitted.get()) {
            throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Response already committed");
        }
        int n2 = object.getCode();
        if (n2 < 100 || n2 >= 200) {
            throw new HttpException("Invalid intermediate response: " + n2);
        }
        object = DefaultH2ResponseConverter.INSTANCE.convert((HttpResponse)object);
        this.outputChannel.submit((List<Header>)object, false);
    }

    private void commitResponse(HttpResponse object, EntityDetails entityDetails) throws HttpException, IOException {
        if (this.responseCommitted.compareAndSet(false, true)) {
            int n2 = object.getCode();
            if (n2 < 200) {
                throw new HttpException("Invalid response: " + n2);
            }
            this.context.setResponse((HttpResponse)object);
            this.httpProcessor.process((HttpResponse)object, entityDetails, (HttpContext)this.context);
            object = DefaultH2ResponseConverter.INSTANCE.convert((HttpResponse)object);
            boolean bl2 = entityDetails == null || this.receivedRequest != null && Method.HEAD.isSame(this.receivedRequest.getMethod());
            if (!bl2) {
                this.outputChannel.submit((List<Header>)object, false);
                this.connMetrics.incrementResponseCount();
                this.exchangeHandler.produce(this.outputChannel);
                if (this.responseState.compareAndSet(MessageState.IDLE, MessageState.BODY)) {
                    this.outputChannel.requestOutput();
                }
                return;
            }
        } else {
            throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Response already committed");
        }
        this.responseState.set(MessageState.COMPLETE);
        this.outputChannel.submit((List<Header>)object, true);
        this.connMetrics.incrementResponseCount();
    }

    private void commitPromise(HttpRequest object, AsyncPushProducer asyncPushProducer) throws HttpException, IOException {
        this.httpProcessor.process((HttpRequest)object, null, (HttpContext)this.context);
        object = DefaultH2RequestConverter.INSTANCE.convert((HttpRequest)object);
        this.outputChannel.push((List<Header>)object, asyncPushProducer);
        this.connMetrics.incrementRequestCount();
    }

    @Override
    public void consumePromise(List<Header> list) throws HttpException, IOException {
        throw new ProtocolException("Unexpected message promise");
    }

    @Override
    public void consumeHeader(List<Header> object, boolean bl2) throws HttpException, IOException {
        if (this.done.get()) {
            throw new ProtocolException("Unexpected message headers");
        }
        switch (this.requestState.get()) {
            case HEADERS: {
                AsyncServerExchangeHandler asyncServerExchangeHandler;
                this.requestState.set(bl2 ? MessageState.COMPLETE : MessageState.BODY);
                object = DefaultH2RequestConverter.INSTANCE.convert((List)object);
                IncomingEntityDetails incomingEntityDetails = bl2 ? null : new IncomingEntityDetails((MessageHeaders)object, -1L);
                try {
                    asyncServerExchangeHandler = this.exchangeHandlerFactory != null ? this.exchangeHandlerFactory.create((HttpRequest)object, this.context) : null;
                }
                catch (ProtocolException protocolException) {
                    throw new H2StreamResetException(H2Error.PROTOCOL_ERROR, protocolException.getMessage());
                }
                if (asyncServerExchangeHandler == null) {
                    throw new H2StreamResetException(H2Error.REFUSED_STREAM, "Stream refused");
                }
                this.exchangeHandler = asyncServerExchangeHandler;
                this.context.setProtocolVersion(HttpVersion.HTTP_2);
                this.context.setRequest((HttpRequest)object);
                try {
                    this.httpProcessor.process((HttpRequest)object, (EntityDetails)incomingEntityDetails, (HttpContext)this.context);
                    this.connMetrics.incrementRequestCount();
                    this.receivedRequest = object;
                    this.exchangeHandler.handleRequest((HttpRequest)object, incomingEntityDetails, this.responseChannel, this.context);
                    return;
                }
                catch (HttpException httpException) {
                    if (!this.responseCommitted.get()) {
                        BasicResponseProducer basicResponseProducer = new BasicResponseProducer(ServerSupport.toStatusCode(httpException), ServerSupport.toErrorMessage(httpException));
                        this.exchangeHandler = new ImmediateResponseExchangeHandler(basicResponseProducer);
                        this.exchangeHandler.handleRequest((HttpRequest)object, incomingEntityDetails, this.responseChannel, this.context);
                        break;
                    }
                    throw httpException;
                }
            }
            case BODY: {
                this.responseState.set(MessageState.COMPLETE);
                this.exchangeHandler.streamEnd((List<? extends Header>)object);
                return;
            }
            default: {
                throw new ProtocolException("Unexpected message headers");
            }
        }
    }

    @Override
    public void updateInputCapacity() throws IOException {
        Asserts.notNull(this.exchangeHandler, "Exchange handler");
        this.exchangeHandler.updateCapacity(this.outputChannel);
    }

    @Override
    public void consumeData(ByteBuffer byteBuffer, boolean bl2) throws HttpException, IOException {
        if (this.done.get() || this.requestState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        Asserts.notNull(this.exchangeHandler, "Exchange handler");
        if (byteBuffer != null) {
            this.exchangeHandler.consume(byteBuffer);
        }
        if (bl2) {
            this.requestState.set(MessageState.COMPLETE);
            this.exchangeHandler.streamEnd(null);
        }
    }

    @Override
    public boolean isOutputReady() {
        return this.responseState.get() == MessageState.BODY && this.exchangeHandler != null && this.exchangeHandler.available() > 0;
    }

    @Override
    public void produceOutput() throws HttpException, IOException {
        if (this.responseState.get() == MessageState.BODY) {
            Asserts.notNull(this.exchangeHandler, "Exchange handler");
            this.exchangeHandler.produce(this.dataChannel);
        }
    }

    @Override
    public void handle(HttpException object, boolean bl2) throws HttpException, IOException {
        if (this.done.get()) {
            throw object;
        }
        switch (this.requestState.get()) {
            case HEADERS: {
                this.requestState.set(bl2 ? MessageState.COMPLETE : MessageState.BODY);
                if (!this.responseCommitted.get()) {
                    object = new BasicResponseProducer(ServerSupport.toStatusCode((Exception)object), ServerSupport.toErrorMessage((Exception)object));
                    this.exchangeHandler = new ImmediateResponseExchangeHandler((AsyncResponseProducer)object);
                    this.exchangeHandler.handleRequest(null, null, this.responseChannel, this.context);
                    return;
                }
                throw object;
            }
            case BODY: {
                this.responseState.set(MessageState.COMPLETE);
            }
        }
        throw object;
    }

    @Override
    public void failed(Exception exception) {
        try {
            if (this.failed.compareAndSet(false, true) && this.exchangeHandler != null) {
                this.exchangeHandler.failed(exception);
            }
            return;
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.requestState.set(MessageState.COMPLETE);
            this.responseState.set(MessageState.COMPLETE);
            if (this.exchangeHandler != null) {
                this.exchangeHandler.releaseResources();
            }
        }
    }

    public String toString() {
        return "[requestState=" + (Object)((Object)this.requestState.get()) + ", responseState=" + (Object)((Object)this.responseState.get()) + ']';
    }

    static /* synthetic */ AtomicReference access$000(ServerH2StreamHandler serverH2StreamHandler) {
        return serverH2StreamHandler.responseState;
    }

    static /* synthetic */ void access$100(ServerH2StreamHandler serverH2StreamHandler, HttpResponse httpResponse) throws IOException, HttpException {
        serverH2StreamHandler.commitInformation(httpResponse);
    }

    static /* synthetic */ void access$200(ServerH2StreamHandler serverH2StreamHandler, HttpResponse httpResponse, EntityDetails entityDetails) throws HttpException, IOException {
        serverH2StreamHandler.commitResponse(httpResponse, entityDetails);
    }

    static /* synthetic */ void access$300(ServerH2StreamHandler serverH2StreamHandler, HttpRequest httpRequest, AsyncPushProducer asyncPushProducer) throws HttpException, IOException {
        serverH2StreamHandler.commitPromise(httpRequest, asyncPushProducer);
    }
}

