/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ServerHttp1UpgradeHandler
implements ProtocolUpgradeHandler {
    private final ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory;

    public ServerHttp1UpgradeHandler(ServerHttp1StreamDuplexerFactory serverHttp1StreamDuplexerFactory) {
        this.http1StreamHandlerFactory = Args.notNull(serverHttp1StreamDuplexerFactory, "HTTP/1.1 stream handler factory");
    }

    @Override
    public void upgrade(ProtocolIOSession protocolIOSession, FutureCallback<ProtocolIOSession> futureCallback) {
        Object object = protocolIOSession.getTlsDetails();
        object = new ServerHttp1IOEventHandler(this.http1StreamHandlerFactory.create(object != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id, protocolIOSession));
        protocolIOSession.upgrade((IOEventHandler)object);
        protocolIOSession.upgrade((IOEventHandler)object);
        try {
            ((ServerHttp1IOEventHandler)object).connected(protocolIOSession);
            if (futureCallback != null) {
                futureCallback.completed(protocolIOSession);
            }
            return;
        }
        catch (IOException iOException) {
            ((ServerHttp1IOEventHandler)object).exception(protocolIOSession, iOException);
            return;
        }
    }
}

