/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.nio.MessageState;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.impl.DefaultH2RequestConverter;
import org.apache.hc.core5.http2.impl.DefaultH2ResponseConverter;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.ServerPushH2StreamHandler$1;
import org.apache.hc.core5.http2.impl.nio.ServerPushH2StreamHandler$2;

class ServerPushH2StreamHandler
implements H2StreamHandler {
    private final H2StreamChannel outputChannel;
    private final DataStreamChannel dataChannel;
    private final HttpProcessor httpProcessor;
    private final BasicHttpConnectionMetrics connMetrics;
    private final AsyncPushProducer pushProducer;
    private final HttpCoreContext context;
    private final AtomicBoolean responseCommitted;
    private final AtomicBoolean failed;
    private final AtomicBoolean done;
    private volatile MessageState requestState;
    private volatile MessageState responseState;

    ServerPushH2StreamHandler(H2StreamChannel h2StreamChannel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics basicHttpConnectionMetrics, AsyncPushProducer asyncPushProducer, HttpCoreContext httpCoreContext) {
        this.outputChannel = h2StreamChannel;
        this.dataChannel = new ServerPushH2StreamHandler$1(this, h2StreamChannel);
        this.httpProcessor = httpProcessor;
        this.connMetrics = basicHttpConnectionMetrics;
        this.pushProducer = asyncPushProducer;
        this.context = httpCoreContext;
        this.responseCommitted = new AtomicBoolean();
        this.failed = new AtomicBoolean();
        this.done = new AtomicBoolean();
        this.requestState = MessageState.COMPLETE;
        this.responseState = MessageState.IDLE;
    }

    @Override
    public HandlerFactory<AsyncPushConsumer> getPushHandlerFactory() {
        return null;
    }

    @Override
    public void consumePromise(List<Header> list) throws HttpException, IOException {
        throw new ProtocolException("Unexpected message promise");
    }

    @Override
    public void consumeHeader(List<Header> list, boolean bl2) throws HttpException, IOException {
        throw new ProtocolException("Unexpected message headers");
    }

    @Override
    public void updateInputCapacity() throws IOException {
    }

    @Override
    public void consumeData(ByteBuffer byteBuffer, boolean bl2) throws HttpException, IOException {
        throw new ProtocolException("Unexpected message data");
    }

    @Override
    public boolean isOutputReady() {
        switch (this.responseState) {
            case IDLE: {
                return true;
            }
            case BODY: {
                return this.pushProducer.available() > 0;
            }
        }
        return false;
    }

    private void commitInformation(HttpResponse object) throws IOException, HttpException {
        if (this.responseCommitted.get()) {
            throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Response already committed");
        }
        int n2 = object.getCode();
        if (n2 < 100 || n2 >= 200) {
            throw new HttpException("Invalid intermediate response: " + n2);
        }
        object = DefaultH2ResponseConverter.INSTANCE.convert((HttpResponse)object);
        this.outputChannel.submit((List<Header>)object, false);
    }

    private void commitResponse(HttpResponse object, EntityDetails entityDetails) throws HttpException, IOException {
        if (this.responseCommitted.compareAndSet(false, true)) {
            this.context.setProtocolVersion(HttpVersion.HTTP_2);
            this.context.setResponse((HttpResponse)object);
            this.httpProcessor.process((HttpResponse)object, entityDetails, (HttpContext)this.context);
            object = DefaultH2ResponseConverter.INSTANCE.convert((HttpResponse)object);
            this.outputChannel.submit((List<Header>)object, entityDetails == null);
            this.connMetrics.incrementResponseCount();
            if (entityDetails == null) {
                this.responseState = MessageState.COMPLETE;
                return;
            }
            this.responseState = MessageState.BODY;
            this.pushProducer.produce(this.outputChannel);
        }
    }

    private void commitPromise(HttpRequest object, AsyncPushProducer asyncPushProducer) throws HttpException, IOException {
        this.context.setProtocolVersion(HttpVersion.HTTP_2);
        this.context.setRequest((HttpRequest)object);
        this.httpProcessor.process((HttpRequest)object, null, (HttpContext)this.context);
        object = DefaultH2RequestConverter.INSTANCE.convert((HttpRequest)object);
        this.outputChannel.push((List<Header>)object, asyncPushProducer);
        this.connMetrics.incrementRequestCount();
    }

    @Override
    public void produceOutput() throws HttpException, IOException {
        switch (this.responseState) {
            case IDLE: {
                this.responseState = MessageState.HEADERS;
                this.pushProducer.produceResponse(new ServerPushH2StreamHandler$2(this), this.context);
                return;
            }
            case BODY: {
                this.pushProducer.produce(this.dataChannel);
            }
        }
    }

    @Override
    public void handle(HttpException httpException, boolean bl2) throws HttpException, IOException {
        throw httpException;
    }

    @Override
    public void failed(Exception exception) {
        try {
            if (this.failed.compareAndSet(false, true)) {
                this.pushProducer.failed(exception);
            }
            return;
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.requestState = MessageState.COMPLETE;
            this.responseState = MessageState.COMPLETE;
            this.pushProducer.releaseResources();
        }
    }

    public String toString() {
        return "[requestState=" + (Object)((Object)this.requestState) + ", responseState=" + (Object)((Object)this.responseState) + ']';
    }

    static /* synthetic */ MessageState access$002(ServerPushH2StreamHandler serverPushH2StreamHandler, MessageState messageState) {
        serverPushH2StreamHandler.responseState = messageState;
        return serverPushH2StreamHandler.responseState;
    }

    static /* synthetic */ void access$100(ServerPushH2StreamHandler serverPushH2StreamHandler, HttpResponse httpResponse) throws IOException, HttpException {
        serverPushH2StreamHandler.commitInformation(httpResponse);
    }

    static /* synthetic */ void access$200(ServerPushH2StreamHandler serverPushH2StreamHandler, HttpResponse httpResponse, EntityDetails entityDetails) throws HttpException, IOException {
        serverPushH2StreamHandler.commitResponse(httpResponse, entityDetails);
    }

    static /* synthetic */ void access$300(ServerPushH2StreamHandler serverPushH2StreamHandler, HttpRequest httpRequest, AsyncPushProducer asyncPushProducer) throws HttpException, IOException {
        serverPushH2StreamHandler.commitPromise(httpRequest, asyncPushProducer);
    }
}

