/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio.bootstrap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.impl.DefaultAddressResolver;
import org.apache.hc.core5.http.impl.bootstrap.AsyncRequester;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.BasicClientExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http2.impl.nio.bootstrap.CancellableExecution;
import org.apache.hc.core5.http2.impl.nio.bootstrap.H2MultiplexingRequester$1;
import org.apache.hc.core5.http2.impl.nio.bootstrap.H2MultiplexingRequester$2;
import org.apache.hc.core5.http2.nio.pool.H2ConnPool;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class H2MultiplexingRequester
extends AsyncRequester {
    private final H2ConnPool connPool;

    @Internal
    public H2MultiplexingRequester(IOReactorConfig iOReactorConfig, IOEventHandlerFactory iOEventHandlerFactory, Decorator<IOSession> decorator, Callback<Exception> callback, IOSessionListener iOSessionListener, Resolver<HttpHost, InetSocketAddress> resolver, TlsStrategy tlsStrategy) {
        super(iOEventHandlerFactory, iOReactorConfig, decorator, callback, iOSessionListener, ShutdownCommand.GRACEFUL_IMMEDIATE_CALLBACK, DefaultAddressResolver.INSTANCE);
        this.connPool = new H2ConnPool(this, resolver, tlsStrategy);
    }

    public void closeIdle(TimeValue timeValue) {
        this.connPool.closeIdle(timeValue);
    }

    public Set<HttpHost> getRoutes() {
        return this.connPool.getRoutes();
    }

    public TimeValue getValidateAfterInactivity() {
        return this.connPool.getValidateAfterInactivity();
    }

    public void setValidateAfterInactivity(TimeValue timeValue) {
        this.connPool.setValidateAfterInactivity(timeValue);
    }

    public Cancellable execute(HttpHost httpHost, AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, Timeout timeout, HttpContext httpContext) {
        Args.notNull(asyncClientExchangeHandler, "Exchange handler");
        Args.notNull(timeout, "Timeout");
        Args.notNull(httpContext, "Context");
        CancellableExecution cancellableExecution = new CancellableExecution();
        this.execute(httpHost, asyncClientExchangeHandler, handlerFactory, cancellableExecution, timeout, httpContext);
        return cancellableExecution;
    }

    public Cancellable execute(AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, Timeout timeout, HttpContext httpContext) {
        return this.execute(null, asyncClientExchangeHandler, handlerFactory, timeout, httpContext);
    }

    public Cancellable execute(HttpHost httpHost, AsyncClientExchangeHandler asyncClientExchangeHandler, Timeout timeout, HttpContext httpContext) {
        return this.execute(httpHost, asyncClientExchangeHandler, null, timeout, httpContext);
    }

    public Cancellable execute(AsyncClientExchangeHandler asyncClientExchangeHandler, Timeout timeout, HttpContext httpContext) {
        return this.execute(null, asyncClientExchangeHandler, null, timeout, httpContext);
    }

    private void execute(HttpHost httpHost, AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, CancellableDependency cancellableDependency, Timeout timeout, HttpContext httpContext) {
        Args.notNull(asyncClientExchangeHandler, "Exchange handler");
        Args.notNull(timeout, "Timeout");
        Args.notNull(httpContext, "Context");
        try {
            asyncClientExchangeHandler.produceRequest((httpRequest, entityDetails, httpContext2) -> {
                HttpHost httpHost2 = httpHost = httpHost != null ? httpHost : H2MultiplexingRequester.defaultTarget(httpRequest);
                if (httpRequest.getAuthority() == null) {
                    httpRequest.setAuthority(new URIAuthority(httpHost.getHostName(), httpHost.getPort()));
                }
                this.connPool.getSession(httpHost, timeout, new H2MultiplexingRequester$1(this, asyncClientExchangeHandler, httpRequest, entityDetails, handlerFactory, cancellableDependency, httpContext));
            }, httpContext);
            return;
        }
        catch (IOException | HttpException exception) {
            asyncClientExchangeHandler.failed(exception);
            return;
        }
    }

    public final <T> Future<T> execute(HttpHost httpHost, AsyncRequestProducer asyncDataProducer, AsyncResponseConsumer<T> asyncResponseConsumer, HandlerFactory<AsyncPushConsumer> handlerFactory, Timeout timeout, HttpContext httpContext, FutureCallback<T> object) {
        Args.notNull(asyncDataProducer, "Request producer");
        Args.notNull(asyncResponseConsumer, "Response consumer");
        Args.notNull(timeout, "Timeout");
        Object object2 = object = new ComplexFuture<T>(object);
        asyncDataProducer = new BasicClientExchangeHandler<T>((AsyncRequestProducer)asyncDataProducer, asyncResponseConsumer, new H2MultiplexingRequester$2(this, (BasicFuture)object2, (ComplexFuture)object2));
        this.execute(httpHost, (AsyncClientExchangeHandler)asyncDataProducer, handlerFactory, (CancellableDependency)object, timeout, httpContext != null ? httpContext : HttpCoreContext.create());
        return object;
    }

    public final <T> Future<T> execute(AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, HandlerFactory<AsyncPushConsumer> handlerFactory, Timeout timeout, HttpContext httpContext, FutureCallback<T> futureCallback) {
        return this.execute(null, asyncRequestProducer, asyncResponseConsumer, handlerFactory, timeout, httpContext, futureCallback);
    }

    public final <T> Future<T> execute(HttpHost httpHost, AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, Timeout timeout, HttpContext httpContext, FutureCallback<T> futureCallback) {
        return this.execute(httpHost, asyncRequestProducer, asyncResponseConsumer, null, timeout, httpContext, futureCallback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, Timeout timeout, HttpContext httpContext, FutureCallback<T> futureCallback) {
        return this.execute(null, asyncRequestProducer, asyncResponseConsumer, null, timeout, httpContext, futureCallback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer asyncRequestProducer, AsyncResponseConsumer<T> asyncResponseConsumer, Timeout timeout, FutureCallback<T> futureCallback) {
        return this.execute(null, asyncRequestProducer, asyncResponseConsumer, null, timeout, null, futureCallback);
    }

    @Internal
    public H2ConnPool getConnPool() {
        return this.connPool;
    }
}

