/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.NamedElementChain;
import org.apache.hc.core5.http.config.NamedElementChain$Node;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import org.apache.hc.core5.http.impl.nio.DefaultHttpRequestParserFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpResponseWriterFactory;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.impl.routing.RequestRouter$Entry;
import org.apache.hc.core5.http.nio.AsyncFilterHandler;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.AsyncServerExpectationFilter;
import org.apache.hc.core5.http.nio.support.AsyncServerFilterChainElement;
import org.apache.hc.core5.http.nio.support.AsyncServerFilterChainExchangeHandlerFactory;
import org.apache.hc.core5.http.nio.support.BasicAsyncServerExpectationDecorator;
import org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import org.apache.hc.core5.http.nio.support.DefaultAsyncResponseExchangeHandlerFactory;
import org.apache.hc.core5.http.nio.support.TerminalAsyncServerFilter;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.LookupRegistry;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http.protocol.UriPatternMatcher;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.H2Processors;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ServerHttpProtocolNegotiationStarter;
import org.apache.hc.core5.http2.impl.nio.bootstrap.FilterEntry;
import org.apache.hc.core5.http2.impl.nio.bootstrap.FilterEntry$Position;
import org.apache.hc.core5.http2.ssl.H2ServerTlsStrategy;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

public class H2ServerBootstrap {
    private final List<RequestRouter$Entry<Supplier<AsyncServerExchangeHandler>>> routeEntries = new ArrayList<RequestRouter$Entry<Supplier<AsyncServerExchangeHandler>>>();
    private final List<FilterEntry<AsyncFilterHandler>> filters = new ArrayList<FilterEntry<AsyncFilterHandler>>();
    private String canonicalHostName;
    private LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry;
    private HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> requestRouter;
    private IOReactorConfig ioReactorConfig;
    private HttpProcessor httpProcessor;
    private CharCodingConfig charCodingConfig;
    private HttpVersionPolicy versionPolicy;
    private H2Config h2Config;
    private Http1Config http1Config;
    private TlsStrategy tlsStrategy;
    private Timeout handshakeTimeout;
    private Decorator<IOSession> ioSessionDecorator;
    private Callback<Exception> exceptionCallback;
    private IOSessionListener sessionListener;
    private H2StreamListener h2StreamListener;
    private Http1StreamListener http1StreamListener;

    private H2ServerBootstrap() {
    }

    public static H2ServerBootstrap bootstrap() {
        return new H2ServerBootstrap();
    }

    public final H2ServerBootstrap setCanonicalHostName(String string) {
        this.canonicalHostName = string;
        return this;
    }

    public final H2ServerBootstrap setIOReactorConfig(IOReactorConfig iOReactorConfig) {
        this.ioReactorConfig = iOReactorConfig;
        return this;
    }

    public final H2ServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final H2ServerBootstrap setVersionPolicy(HttpVersionPolicy httpVersionPolicy) {
        this.versionPolicy = httpVersionPolicy;
        return this;
    }

    public final H2ServerBootstrap setH2Config(H2Config h2Config) {
        this.h2Config = h2Config;
        return this;
    }

    public final H2ServerBootstrap setHttp1Config(Http1Config http1Config) {
        this.http1Config = http1Config;
        return this;
    }

    public final H2ServerBootstrap setCharset(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final H2ServerBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final H2ServerBootstrap setHandshakeTimeout(Timeout timeout) {
        this.handshakeTimeout = timeout;
        return this;
    }

    public final H2ServerBootstrap setIOSessionDecorator(Decorator<IOSession> decorator) {
        this.ioSessionDecorator = decorator;
        return this;
    }

    public final H2ServerBootstrap setExceptionCallback(Callback<Exception> callback) {
        this.exceptionCallback = callback;
        return this;
    }

    public final H2ServerBootstrap setIOSessionListener(IOSessionListener iOSessionListener) {
        this.sessionListener = iOSessionListener;
        return this;
    }

    public final H2ServerBootstrap setStreamListener(H2StreamListener h2StreamListener) {
        this.h2StreamListener = h2StreamListener;
        return this;
    }

    public final H2ServerBootstrap setStreamListener(Http1StreamListener http1StreamListener) {
        this.http1StreamListener = http1StreamListener;
        return this;
    }

    @Deprecated
    public final H2ServerBootstrap setLookupRegistry(LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry) {
        this.lookupRegistry = lookupRegistry;
        return this;
    }

    public final H2ServerBootstrap setRequestRouter(HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> httpRequestMapper) {
        this.requestRouter = httpRequestMapper;
        return this;
    }

    public final H2ServerBootstrap register(String string, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(string, "URI pattern");
        Args.notNull(supplier, "Exchange handler supplier");
        this.routeEntries.add(new RequestRouter$Entry<Supplier<AsyncServerExchangeHandler>>(string, supplier));
        return this;
    }

    public final H2ServerBootstrap register(String string, String string2, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(string, "Hostname");
        Args.notBlank(string2, "URI pattern");
        Args.notNull(supplier, "Exchange handler supplier");
        this.routeEntries.add(new RequestRouter$Entry<Supplier<AsyncServerExchangeHandler>>(string, string2, supplier));
        return this;
    }

    @Deprecated
    public final H2ServerBootstrap registerVirtual(String string, String string2, Supplier<AsyncServerExchangeHandler> supplier) {
        return this.register(string, string2, supplier);
    }

    public final <T> H2ServerBootstrap register(String string, AsyncServerRequestHandler<T> asyncServerRequestHandler) {
        this.register(string, () -> new BasicServerExchangeHandler(asyncServerRequestHandler));
        return this;
    }

    public final <T> H2ServerBootstrap register(String string, String string2, AsyncServerRequestHandler<T> asyncServerRequestHandler) {
        this.registerVirtual(string, string2, () -> new BasicServerExchangeHandler(asyncServerRequestHandler));
        return this;
    }

    @Deprecated
    public final <T> H2ServerBootstrap registerVirtual(String string, String string2, AsyncServerRequestHandler<T> asyncServerRequestHandler) {
        return this.register(string, string2, asyncServerRequestHandler);
    }

    public final H2ServerBootstrap addFilterBefore(String string, String string2, AsyncFilterHandler asyncFilterHandler) {
        Args.notBlank(string, "Existing");
        Args.notBlank(string2, "Name");
        Args.notNull(asyncFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry$Position.BEFORE, string2, asyncFilterHandler, string));
        return this;
    }

    public final H2ServerBootstrap addFilterAfter(String string, String string2, AsyncFilterHandler asyncFilterHandler) {
        Args.notBlank(string, "Existing");
        Args.notBlank(string2, "Name");
        Args.notNull(asyncFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry$Position.AFTER, string2, asyncFilterHandler, string));
        return this;
    }

    public final H2ServerBootstrap replaceFilter(String string, AsyncFilterHandler asyncFilterHandler) {
        Args.notBlank(string, "Existing");
        Args.notNull(asyncFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry$Position.REPLACE, string, asyncFilterHandler, string));
        return this;
    }

    public final H2ServerBootstrap addFilterFirst(String string, AsyncFilterHandler asyncFilterHandler) {
        Args.notNull(string, "Name");
        Args.notNull(asyncFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry$Position.FIRST, string, asyncFilterHandler, null));
        return this;
    }

    public final H2ServerBootstrap addFilterLast(String string, AsyncFilterHandler asyncFilterHandler) {
        Args.notNull(string, "Name");
        Args.notNull(asyncFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry$Position.LAST, string, asyncFilterHandler, null));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpAsyncServer create() {
        Object object;
        HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> httpRequestMapper2;
        String string;
        String string2 = string = this.canonicalHostName != null ? this.canonicalHostName : InetAddressUtils.getCanonicalLocalHostName();
        if (this.lookupRegistry != null && this.requestRouter == null) {
            httpRequestMapper2 = new RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>>(string, () -> {
                if (this.lookupRegistry != null) {
                    return this.lookupRegistry;
                }
                return new UriPatternMatcher();
            });
            for (RequestRouter$Entry object22 : this.routeEntries) {
                ((RequestHandlerRegistry)httpRequestMapper2).register(object22.uriAuthority != null ? object22.uriAuthority.getHostName() : null, (String)object22.route.pattern, (Supplier<AsyncServerExchangeHandler>)object22.route.handler);
            }
        } else {
            httpRequestMapper2 = this.routeEntries.isEmpty() ? this.requestRouter : RequestRouter.create(new URIAuthority(string), UriPatternType.URI_PATTERN, this.routeEntries, RequestRouter.IGNORE_PORT_AUTHORITY_RESOLVER, this.requestRouter);
        }
        if (!this.filters.isEmpty()) {
            void var4_7;
            object = new NamedElementChain<TerminalAsyncServerFilter>();
            ((NamedElementChain)object).addLast(new TerminalAsyncServerFilter(new DefaultAsyncResponseExchangeHandlerFactory(httpRequestMapper2)), StandardFilter.MAIN_HANDLER.name());
            ((NamedElementChain)object).addFirst(new AsyncServerExpectationFilter(), StandardFilter.EXPECT_CONTINUE.name());
            for (HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> httpRequestMapper2 : this.filters) {
                switch (((FilterEntry)((Object)httpRequestMapper2)).position) {
                    case AFTER: {
                        ((NamedElementChain)object).addAfter(((FilterEntry)((Object)httpRequestMapper2)).existing, ((FilterEntry)((Object)httpRequestMapper2)).filterHandler, ((FilterEntry)((Object)httpRequestMapper2)).name);
                        break;
                    }
                    case BEFORE: {
                        ((NamedElementChain)object).addBefore(((FilterEntry)((Object)httpRequestMapper2)).existing, ((FilterEntry)((Object)httpRequestMapper2)).filterHandler, ((FilterEntry)((Object)httpRequestMapper2)).name);
                        break;
                    }
                    case REPLACE: {
                        ((NamedElementChain)object).replace(((FilterEntry)((Object)httpRequestMapper2)).existing, ((FilterEntry)((Object)httpRequestMapper2)).filterHandler);
                        break;
                    }
                    case FIRST: {
                        ((NamedElementChain)object).addFirst(((FilterEntry)((Object)httpRequestMapper2)).filterHandler, ((FilterEntry)((Object)httpRequestMapper2)).name);
                        break;
                    }
                    case LAST: {
                        ((NamedElementChain)object).addBefore(StandardFilter.MAIN_HANDLER.name(), ((FilterEntry)((Object)httpRequestMapper2)).filterHandler, ((FilterEntry)((Object)httpRequestMapper2)).name);
                    }
                }
            }
            NamedElementChain$Node namedElementChain$Node = ((NamedElementChain)object).getLast();
            httpRequestMapper2 = null;
            while (var4_7 != null) {
                httpRequestMapper2 = new AsyncServerFilterChainElement((AsyncFilterHandler)var4_7.getValue(), (AsyncServerFilterChainElement)((Object)httpRequestMapper2));
                NamedElementChain$Node namedElementChain$Node2 = var4_7.getPrevious();
            }
            httpRequestMapper2 = new AsyncServerFilterChainExchangeHandlerFactory((AsyncServerFilterChainElement)((Object)httpRequestMapper2), this.exceptionCallback);
        } else {
            httpRequestMapper2 = new DefaultAsyncResponseExchangeHandlerFactory(httpRequestMapper2, asyncServerExchangeHandler -> new BasicAsyncServerExpectationDecorator((AsyncServerExchangeHandler)asyncServerExchangeHandler, this.exceptionCallback));
        }
        object = new ServerH2StreamMultiplexerFactory(this.httpProcessor != null ? this.httpProcessor : H2Processors.server(), (HandlerFactory<AsyncServerExchangeHandler>)((Object)httpRequestMapper2), this.h2Config != null ? this.h2Config : H2Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.h2StreamListener);
        TlsStrategy tlsStrategy = this.tlsStrategy != null ? this.tlsStrategy : new H2ServerTlsStrategy();
        DefaultContentLengthStrategy defaultContentLengthStrategy = DefaultContentLengthStrategy.INSTANCE;
        httpRequestMapper2 = new ServerHttp1StreamDuplexerFactory(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), (HandlerFactory<AsyncServerExchangeHandler>)((Object)httpRequestMapper2), this.http1Config != null ? this.http1Config : Http1Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, DefaultConnectionReuseStrategy.INSTANCE, new DefaultHttpRequestParserFactory(this.http1Config), new DefaultHttpResponseWriterFactory(this.http1Config), defaultContentLengthStrategy, defaultContentLengthStrategy, this.http1StreamListener, this.exceptionCallback);
        httpRequestMapper2 = new ServerHttpProtocolNegotiationStarter((ServerHttp1StreamDuplexerFactory)((Object)httpRequestMapper2), (ServerH2StreamMultiplexerFactory)object, this.versionPolicy != null ? this.versionPolicy : HttpVersionPolicy.NEGOTIATE, tlsStrategy, this.handshakeTimeout, this.exceptionCallback);
        return new HttpAsyncServer((IOEventHandlerFactory)((Object)httpRequestMapper2), this.ioReactorConfig, this.ioSessionDecorator, this.exceptionCallback, this.sessionListener, string);
    }
}

