/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.nio.pool;

import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.impl.DefaultAddressResolver;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.http2.nio.pool.H2ConnPool$1;
import org.apache.hc.core5.http2.nio.support.BasicPingHandler;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.AbstractIOSessionPool;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.SAFE)
public final class H2ConnPool
extends AbstractIOSessionPool<HttpHost> {
    private final ConnectionInitiator connectionInitiator;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;
    private final TlsStrategy tlsStrategy;
    private volatile TimeValue validateAfterInactivity = TimeValue.NEG_ONE_MILLISECOND;

    public H2ConnPool(ConnectionInitiator connectionInitiator, Resolver<HttpHost, InetSocketAddress> defaultAddressResolver, TlsStrategy tlsStrategy) {
        this.connectionInitiator = Args.notNull(connectionInitiator, "Connection initiator");
        this.addressResolver = defaultAddressResolver != null ? defaultAddressResolver : DefaultAddressResolver.INSTANCE;
        this.tlsStrategy = tlsStrategy;
    }

    public final TimeValue getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public final void setValidateAfterInactivity(TimeValue timeValue) {
        this.validateAfterInactivity = timeValue;
    }

    @Override
    protected final void closeSession(IOSession iOSession, CloseMode closeMode) {
        if (closeMode == CloseMode.GRACEFUL) {
            iOSession.enqueue(ShutdownCommand.GRACEFUL, Command$Priority.NORMAL);
            return;
        }
        iOSession.close(closeMode);
    }

    @Override
    protected final Future<IOSession> connectSession(HttpHost httpHost, Timeout timeout, FutureCallback<IOSession> futureCallback) {
        InetSocketAddress inetSocketAddress = this.addressResolver.resolve(httpHost);
        return this.connectionInitiator.connect(httpHost, inetSocketAddress, null, timeout, null, new H2ConnPool$1(this, futureCallback, httpHost, timeout, futureCallback));
    }

    @Override
    protected final void validateSession(IOSession iOSession, Callback<Boolean> callback) {
        if (iOSession.isOpen()) {
            long l2;
            long l3;
            TimeValue timeValue = this.validateAfterInactivity;
            if (TimeValue.isNonNegative(timeValue) && (l3 = (l2 = Math.min(iOSession.getLastReadTime(), iOSession.getLastWriteTime())) + timeValue.toMilliseconds()) <= System.currentTimeMillis()) {
                timeValue = iOSession.getSocketTimeout();
                iOSession.enqueue(new PingCommand(new BasicPingHandler(arg_0 -> H2ConnPool.lambda$validateSession$0(iOSession, (Timeout)timeValue, callback, arg_0))), Command$Priority.NORMAL);
                return;
            }
            callback.execute(Boolean.TRUE);
            return;
        }
        callback.execute(Boolean.FALSE);
    }

    private static /* synthetic */ void lambda$validateSession$0(IOSession iOSession, Timeout timeout, Callback callback, Boolean bl2) {
        iOSession.setSocketTimeout(timeout);
        callback.execute(bl2);
    }

    static /* synthetic */ TlsStrategy access$000(H2ConnPool h2ConnPool) {
        return h2ConnPool.tlsStrategy;
    }
}

