/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http2.nio.AsyncPingHandler;
import org.apache.hc.core5.util.Args;

public class BasicPingHandler
implements AsyncPingHandler {
    private static final byte[] PING_MESSAGE = new byte[]{42, 42, 112, 105, 110, 103, 42, 42};
    private final Callback<Boolean> callback;

    public BasicPingHandler(Callback<Boolean> callback) {
        this.callback = Args.notNull(callback, "Callback");
    }

    @Override
    public ByteBuffer getData() {
        return ByteBuffer.wrap(PING_MESSAGE);
    }

    @Override
    public void consumeResponse(ByteBuffer byteBuffer) throws HttpException, IOException {
        boolean bl2 = true;
        for (int i2 = 0; i2 < PING_MESSAGE.length; ++i2) {
            if (byteBuffer.hasRemaining() && PING_MESSAGE[i2] == byteBuffer.get()) continue;
            bl2 = false;
            break;
        }
        this.callback.execute(bl2);
    }

    @Override
    public void failed(Exception exception) {
        this.callback.execute(Boolean.FALSE);
    }

    @Override
    public void cancel() {
        this.callback.execute(Boolean.FALSE);
    }
}

