/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2RequestContent
extends RequestContent {
    public static final H2RequestContent INSTANCE = new H2RequestContent();

    public H2RequestContent() {
    }

    public H2RequestContent(boolean bl2) {
        super(bl2);
    }

    @Override
    public void process(HttpRequest httpRequest, EntityDetails entityDetails, HttpContext object) throws HttpException, IOException {
        Args.notNull(object, "HTTP context");
        ProtocolVersion protocolVersion = object.getProtocolVersion();
        if (protocolVersion.getMajor() < 2) {
            super.process(httpRequest, entityDetails, (HttpContext)object);
            return;
        }
        if (entityDetails != null) {
            object = httpRequest.getMethod();
            if (Method.TRACE.isSame((String)object)) {
                throw new ProtocolException("TRACE request may not enclose an entity");
            }
            MessageSupport.addContentTypeHeader(httpRequest, entityDetails);
            MessageSupport.addContentEncodingHeader(httpRequest, entityDetails);
            MessageSupport.addTrailerHeader(httpRequest, entityDetails);
            this.validateOptionsContentType(httpRequest);
        }
    }
}

