/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.ResponseContent;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2ResponseContent
extends ResponseContent {
    public static final H2ResponseContent INSTANCE = new H2ResponseContent();

    public H2ResponseContent() {
    }

    public H2ResponseContent(boolean bl2) {
        super(bl2);
    }

    @Override
    public void process(HttpResponse httpResponse, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpContext, "HTTP context");
        ProtocolVersion protocolVersion = httpContext.getProtocolVersion();
        if (protocolVersion.getMajor() < 2) {
            super.process(httpResponse, entityDetails, httpContext);
            return;
        }
        if (entityDetails != null) {
            MessageSupport.addContentTypeHeader(httpResponse, entityDetails);
            MessageSupport.addContentEncodingHeader(httpResponse, entityDetails);
            MessageSupport.addTrailerHeader(httpResponse, entityDetails);
        }
    }
}

