/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.ssl;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.http.ssl.TlsCiphers;
import org.apache.hc.core5.http2.ssl.H2TlsSupport;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.conscrypt.Conscrypt;

public final class ConscryptSupport {
    public static SSLSessionInitializer initialize(Object object, SSLSessionInitializer sSLSessionInitializer) {
        return (namedEndpoint, sSLEngine) -> {
            SSLParameters sSLParameters = sSLEngine.getSSLParameters();
            sSLParameters.setProtocols(TLS.excludeWeak(sSLParameters.getProtocols()));
            SSLParameters sSLParameters2 = sSLParameters;
            sSLParameters2.setCipherSuites(TlsCiphers.excludeH2Blacklisted(sSLParameters2.getCipherSuites()));
            H2TlsSupport.setEnableRetransmissions(sSLParameters, false);
            object = H2TlsSupport.selectApplicationProtocols(object);
            if (Conscrypt.isConscrypt((SSLEngine)sSLEngine)) {
                sSLEngine.setSSLParameters(sSLParameters);
                Conscrypt.setApplicationProtocols((SSLEngine)sSLEngine, (String[])object);
            } else {
                sSLParameters.setApplicationProtocols((String[])object);
                sSLEngine.setSSLParameters(sSLParameters);
            }
            if (sSLSessionInitializer != null) {
                sSLSessionInitializer.initialize(namedEndpoint, sSLEngine);
            }
        };
    }

    public static SSLSessionVerifier verify(SSLSessionVerifier sSLSessionVerifier) {
        return (namedEndpoint, sSLEngine) -> {
            if ((sSLSessionVerifier = sSLSessionVerifier != null ? sSLSessionVerifier.verify(namedEndpoint, sSLEngine) : null) == null && Conscrypt.isConscrypt((SSLEngine)sSLEngine)) {
                sSLSessionVerifier = new TlsDetails(sSLEngine.getSession(), Conscrypt.getApplicationProtocol((SSLEngine)sSLEngine));
            }
            return sSLSessionVerifier;
        };
    }
}

