/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.io;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.SocketOption;
import org.apache.hc.core5.annotation.Internal;

@Internal
public class SocketSupport {
    public static final String TCP_KEEPIDLE = "TCP_KEEPIDLE";
    public static final String TCP_KEEPINTERVAL = "TCP_KEEPINTERVAL";
    public static final String TCP_KEEPCOUNT = "TCP_KEEPCOUNT";

    public static <T> SocketOption<T> getExtendedSocketOptionOrNull(String object) {
        try {
            Class<?> clazz = Class.forName("jdk.net.ExtendedSocketOptions");
            object = clazz.getField((String)object);
            return (SocketOption)((Field)object).get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> void setOption(T t2, String string, T t3) throws IOException {
        try {
            GenericDeclaration genericDeclaration = t2.getClass();
            genericDeclaration = ((Class)genericDeclaration).getMethod("setOption", SocketOption.class, Object.class);
            SocketOption<T> socketOption = SocketSupport.getExtendedSocketOptionOrNull(string);
            if (socketOption == null) {
                throw new UnsupportedOperationException("Extended socket option not supported: " + string);
            }
            ((Method)genericDeclaration).invoke(t2, socketOption, t3);
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException2 = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IOException("Failure setting extended socket option", exception);
        }
    }
}

