/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.apache.hc.core5.util.Args;

public class InetAddressUtils {
    public static final byte IPV4 = 1;
    public static final byte IPV6 = 4;
    private static final String IPV4_BASIC_PATTERN_STRING = "(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern IPV4_MAPPED_IPV6_PATTERN = Pattern.compile("^::[fF]{4}:(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");
    private static final Pattern SCOPE_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9\\-]+$");
    private static final char SCOPE_ID_DELIMITER = '%';
    private static final char COLON_CHAR = ':';
    private static final int MAX_COLON_COUNT = 7;

    private InetAddressUtils() {
    }

    @Deprecated
    public static boolean isIPv4Address(String string) {
        return InetAddressUtils.isIPv4(string);
    }

    public static boolean isIPv4(CharSequence charSequence) {
        return IPV4_PATTERN.matcher(charSequence).matches();
    }

    @Deprecated
    public static boolean isIPv4MappedIPv64Address(String string) {
        return InetAddressUtils.isIPv4MappedIPv6(string);
    }

    public static boolean isIPv4MappedIPv6(CharSequence charSequence) {
        return IPV4_MAPPED_IPV6_PATTERN.matcher(charSequence).matches();
    }

    static boolean hasValidIPv6ColonCount(CharSequence charSequence) {
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (charSequence.charAt(i2) != ':') continue;
            ++n2;
        }
        return n2 >= 2 && n2 <= 7;
    }

    @Deprecated
    public static boolean isIPv6StdAddress(String string) {
        return InetAddressUtils.isIPv6Std(string);
    }

    public static boolean isIPv6Std(CharSequence charSequence) {
        return InetAddressUtils.hasValidIPv6ColonCount(charSequence) && IPV6_STD_PATTERN.matcher(charSequence).matches();
    }

    @Deprecated
    public static boolean isIPv6HexCompressedAddress(String string) {
        return InetAddressUtils.isIPv6HexCompressed(string);
    }

    public static boolean isIPv6HexCompressed(CharSequence charSequence) {
        return InetAddressUtils.hasValidIPv6ColonCount(charSequence) && IPV6_HEX_COMPRESSED_PATTERN.matcher(charSequence).matches();
    }

    @Deprecated
    public static boolean isIPv6Address(String string) {
        return InetAddressUtils.isIPv6(string);
    }

    public static boolean isIPv6(CharSequence charSequence) {
        int n2 = -1;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (charSequence.charAt(i2) != '%') continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return InetAddressUtils.isIPv6Std(charSequence) || InetAddressUtils.isIPv6HexCompressed(charSequence);
        }
        CharSequence charSequence2 = charSequence.subSequence(0, n2);
        if (InetAddressUtils.isIPv6Std(charSequence2) || InetAddressUtils.isIPv6HexCompressed(charSequence2)) {
            return (charSequence = charSequence.subSequence(n2 + 1, charSequence.length())).length() != 0 && SCOPE_ID_PATTERN.matcher(charSequence).matches();
        }
        return false;
    }

    @Deprecated
    public static boolean isIPv6URLBracketedAddress(String string) {
        return InetAddressUtils.isIPv6URLBracketed(string);
    }

    public static boolean isIPv6URLBracketed(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return false;
        }
        if (charSequence.charAt(0) == '[') {
            CharSequence charSequence2 = charSequence;
            if (charSequence2.charAt(charSequence2.length() - 1) == ']' && InetAddressUtils.isIPv6(charSequence.subSequence(1, charSequence.length() - 1))) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void formatAddress(StringBuilder stringBuilder, SocketAddress socketAddress) {
        Args.notNull(stringBuilder, "buffer");
        if (!(socketAddress instanceof InetSocketAddress)) {
            stringBuilder.append(socketAddress);
            return;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress != null) {
            stringBuilder.append(inetAddress.getHostAddress()).append(':').append(inetSocketAddress.getPort());
            return;
        }
        stringBuilder.append(socketAddress);
    }

    public static String getCanonicalLocalHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }
}

