/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.SocketModalCloseable;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.DisposalCallback;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Internal
public final class DefaultDisposalCallback<T extends SocketModalCloseable>
implements DisposalCallback<T> {
    private static final Timeout DEFAULT_CLOSE_TIMEOUT = Timeout.ofSeconds(1L);

    @Override
    public final void execute(SocketModalCloseable socketModalCloseable, CloseMode closeMode) {
        Timeout timeout = socketModalCloseable.getSocketTimeout();
        if (timeout == null || timeout.compareTo(TimeValue.ZERO_MILLISECONDS) <= 0 || timeout.compareTo(DEFAULT_CLOSE_TIMEOUT) > 0) {
            socketModalCloseable.setSocketTimeout(DEFAULT_CLOSE_TIMEOUT);
        }
        socketModalCloseable.close(closeMode);
    }
}

