/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicMarkableReference;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.ConnPoolListener;
import org.apache.hc.core5.pool.ConnPoolStats;
import org.apache.hc.core5.pool.DisposalCallback;
import org.apache.hc.core5.pool.LaxConnPool$LeaseRequest;
import org.apache.hc.core5.pool.LaxConnPool$PerRoutePool$1;
import org.apache.hc.core5.pool.LaxConnPool$PerRoutePool$RequestServiceStrategy;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.DeadlineTimeoutException;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

class LaxConnPool$PerRoutePool<T, C extends ModalCloseable> {
    private final T route;
    private final TimeValue timeToLive;
    private final PoolReusePolicy policy;
    private final DisposalCallback<C> disposalCallback;
    private final ConnPoolListener<T> connPoolListener;
    private final ConnPoolStats<T> connPoolStats;
    private final ConcurrentMap<PoolEntry<T, C>, Boolean> leased;
    private final Deque<AtomicMarkableReference<PoolEntry<T, C>>> available;
    private final Deque<LaxConnPool$LeaseRequest<T, C>> pending;
    private final AtomicBoolean terminated;
    private final AtomicInteger allocated;
    private final AtomicLong releaseSeqNum;
    private volatile int max;

    LaxConnPool$PerRoutePool(T t2, int n2, TimeValue timeValue, PoolReusePolicy poolReusePolicy, ConnPoolStats<T> connPoolStats, DisposalCallback<C> disposalCallback, ConnPoolListener<T> connPoolListener) {
        this.route = t2;
        this.timeToLive = timeValue;
        this.policy = poolReusePolicy;
        this.connPoolStats = connPoolStats;
        this.disposalCallback = disposalCallback;
        this.connPoolListener = connPoolListener;
        this.leased = new ConcurrentHashMap<PoolEntry<T, C>, Boolean>();
        this.available = new ConcurrentLinkedDeque<AtomicMarkableReference<PoolEntry<T, C>>>();
        this.pending = new ConcurrentLinkedDeque<LaxConnPool$LeaseRequest<T, C>>();
        this.terminated = new AtomicBoolean();
        this.allocated = new AtomicInteger(0);
        this.releaseSeqNum = new AtomicLong(0L);
        this.max = n2;
    }

    public void shutdown(CloseMode closeMode) {
        if (this.terminated.compareAndSet(false, true)) {
            LaxConnPool$LeaseRequest<T, C> laxConnPool$LeaseRequest;
            while ((laxConnPool$LeaseRequest = this.available.poll()) != null) {
                ((AtomicMarkableReference)((Object)laxConnPool$LeaseRequest)).getReference().discardConnection(closeMode);
            }
            laxConnPool$LeaseRequest = this.leased.keySet().iterator();
            while (laxConnPool$LeaseRequest.hasNext()) {
                PoolEntry poolEntry = (PoolEntry)laxConnPool$LeaseRequest.next();
                poolEntry.discardConnection(closeMode);
            }
            this.leased.clear();
            while ((laxConnPool$LeaseRequest = this.pending.poll()) != null) {
                laxConnPool$LeaseRequest.cancel();
            }
        }
    }

    private PoolEntry<T, C> createPoolEntry() {
        int n2;
        int n3;
        int n4 = this.max;
        while (!this.allocated.compareAndSet(n3, n2 = (n3 = this.allocated.get()) < n4 ? n3 + 1 : n3)) {
        }
        if (n3 < n2) {
            return new PoolEntry<T, C>(this.route, this.timeToLive, this.disposalCallback);
        }
        return null;
    }

    private void deallocatePoolEntry() {
        this.allocated.decrementAndGet();
    }

    private void addLeased(PoolEntry<T, C> poolEntry) {
        if (this.leased.putIfAbsent(poolEntry, Boolean.TRUE) != null) {
            throw new IllegalStateException("Pool entry already present in the set of leased entries");
        }
        if (this.connPoolListener != null) {
            this.connPoolListener.onLease(this.route, this.connPoolStats);
        }
    }

    private void removeLeased(PoolEntry<T, C> poolEntry) {
        if (this.connPoolListener != null) {
            this.connPoolListener.onRelease(this.route, this.connPoolStats);
        }
        if (!this.leased.remove(poolEntry, Boolean.TRUE)) {
            throw new IllegalStateException("Pool entry is not present in the set of leased entries");
        }
    }

    private PoolEntry<T, C> getAvailableEntry(Object object) {
        Iterator<AtomicMarkableReference<PoolEntry<T, C>>> iterator = this.available.iterator();
        while (iterator.hasNext()) {
            PoolEntry<T, C> poolEntry;
            AtomicMarkableReference<PoolEntry<T, C>> atomicMarkableReference = iterator.next();
            PoolEntry<T, C> poolEntry2 = poolEntry = atomicMarkableReference.getReference();
            if (!atomicMarkableReference.compareAndSet(poolEntry2, poolEntry2, false, true)) continue;
            iterator.remove();
            if (poolEntry.getExpiryDeadline().isExpired()) {
                poolEntry.discardConnection(CloseMode.GRACEFUL);
            }
            if (!Objects.equals(poolEntry.getState(), object)) {
                poolEntry.discardConnection(CloseMode.GRACEFUL);
            }
            return poolEntry;
        }
        return null;
    }

    public Future<PoolEntry<T, C>> lease(Object object, Timeout timeout, FutureCallback<PoolEntry<T, C>> object2) {
        Asserts.check(!this.terminated.get(), "Connection pool shut down");
        object2 = new LaxConnPool$PerRoutePool$1(this, (FutureCallback)object2);
        long l2 = this.releaseSeqNum.get();
        PoolEntry<T, C> poolEntry = null;
        if (this.pending.isEmpty() && (poolEntry = this.getAvailableEntry(object)) == null) {
            poolEntry = this.createPoolEntry();
        }
        if (poolEntry != null) {
            this.addLeased(poolEntry);
            ((BasicFuture)object2).completed(poolEntry);
        } else {
            this.pending.add(new LaxConnPool$LeaseRequest(object, timeout, object2));
            if (l2 != this.releaseSeqNum.get()) {
                this.servicePendingRequest();
            }
        }
        return object2;
    }

    public void release(PoolEntry<T, C> poolEntry, boolean bl2) {
        block6: {
            block5: {
                this.removeLeased(poolEntry);
                if (!bl2 || poolEntry.getExpiryDeadline().isExpired()) {
                    poolEntry.discardConnection(CloseMode.GRACEFUL);
                }
                if (!poolEntry.hasConnection()) break block5;
                switch (this.policy) {
                    case LIFO: {
                        this.available.addFirst(new AtomicMarkableReference<PoolEntry<T, C>>(poolEntry, false));
                        break block6;
                    }
                    case FIFO: {
                        this.available.addLast(new AtomicMarkableReference<PoolEntry<T, C>>(poolEntry, false));
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected ConnPoolPolicy value: " + (Object)((Object)this.policy));
                    }
                }
            }
            this.deallocatePoolEntry();
        }
        this.releaseSeqNum.incrementAndGet();
        this.servicePendingRequest();
    }

    private void servicePendingRequest() {
        this.servicePendingRequests(LaxConnPool$PerRoutePool$RequestServiceStrategy.FIRST_SUCCESSFUL);
    }

    private void servicePendingRequests(LaxConnPool$PerRoutePool$RequestServiceStrategy laxConnPool$PerRoutePool$RequestServiceStrategy) {
        LaxConnPool$LeaseRequest<T, C> laxConnPool$LeaseRequest;
        while ((laxConnPool$LeaseRequest = this.pending.poll()) != null) {
            if (laxConnPool$LeaseRequest.isDone()) continue;
            PoolEntry<T, C> poolEntry = laxConnPool$LeaseRequest.getState();
            Deadline deadline = laxConnPool$LeaseRequest.getDeadline();
            if (deadline.isExpired()) {
                laxConnPool$LeaseRequest.failed(DeadlineTimeoutException.from(deadline));
                continue;
            }
            long l2 = this.releaseSeqNum.get();
            if ((poolEntry = this.getAvailableEntry(poolEntry)) == null) {
                poolEntry = this.createPoolEntry();
            }
            if (poolEntry != null) {
                this.addLeased(poolEntry);
                if (!laxConnPool$LeaseRequest.completed(poolEntry)) {
                    this.release(poolEntry, true);
                }
                if (laxConnPool$PerRoutePool$RequestServiceStrategy != LaxConnPool$PerRoutePool$RequestServiceStrategy.FIRST_SUCCESSFUL) continue;
                return;
            }
            this.pending.addFirst(laxConnPool$LeaseRequest);
            if (l2 != this.releaseSeqNum.get()) continue;
        }
    }

    public void validatePendingRequests() {
        Iterator<LaxConnPool$LeaseRequest<T, C>> iterator = this.pending.iterator();
        while (iterator.hasNext()) {
            LaxConnPool$LeaseRequest<T, C> laxConnPool$LeaseRequest = iterator.next();
            Object object = laxConnPool$LeaseRequest.getFuture();
            if (((BasicFuture)object).isCancelled() && !laxConnPool$LeaseRequest.isDone()) {
                iterator.remove();
                continue;
            }
            object = laxConnPool$LeaseRequest.getDeadline();
            if (((Deadline)object).isExpired()) {
                laxConnPool$LeaseRequest.failed(DeadlineTimeoutException.from((Deadline)object));
            }
            if (!laxConnPool$LeaseRequest.isDone()) continue;
            iterator.remove();
        }
    }

    public final T getRoute() {
        return this.route;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int n2) {
        this.max = n2;
    }

    public int getPendingCount() {
        return this.pending.size();
    }

    public int getLeasedCount() {
        return this.leased.size();
    }

    public int getAvailableCount() {
        return this.available.size();
    }

    public void enumAvailable(Callback<PoolEntry<T, C>> callback) {
        Iterator<AtomicMarkableReference<PoolEntry<T, C>>> iterator = this.available.iterator();
        while (iterator.hasNext()) {
            PoolEntry<T, C> poolEntry;
            AtomicMarkableReference<PoolEntry<T, C>> atomicMarkableReference = iterator.next();
            PoolEntry<T, C> poolEntry2 = poolEntry = atomicMarkableReference.getReference();
            if (!atomicMarkableReference.compareAndSet(poolEntry2, poolEntry2, false, true)) continue;
            callback.execute(poolEntry);
            if (!poolEntry.hasConnection()) {
                this.deallocatePoolEntry();
                iterator.remove();
                continue;
            }
            atomicMarkableReference.set(poolEntry, false);
        }
        this.releaseSeqNum.incrementAndGet();
        this.servicePendingRequests(LaxConnPool$PerRoutePool$RequestServiceStrategy.ALL);
    }

    public void enumLeased(Callback<PoolEntry<T, C>> callback) {
        Iterator iterator = this.leased.keySet().iterator();
        while (iterator.hasNext()) {
            PoolEntry poolEntry = (PoolEntry)iterator.next();
            callback.execute(poolEntry);
            if (poolEntry.hasConnection()) continue;
            this.deallocatePoolEntry();
            iterator.remove();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[route: ");
        stringBuilder.append(this.route);
        stringBuilder.append("][leased: ");
        stringBuilder.append(this.leased.size());
        stringBuilder.append("][available: ");
        stringBuilder.append(this.available.size());
        stringBuilder.append("][pending: ");
        stringBuilder.append(this.pending.size());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

