/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.ConnPoolListener;
import org.apache.hc.core5.pool.DisposalCallback;
import org.apache.hc.core5.pool.LaxConnPool$PerRoutePool;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.SAFE)
@Experimental
public class LaxConnPool<T, C extends ModalCloseable>
implements ManagedConnPool<T, C> {
    private final TimeValue timeToLive;
    private final PoolReusePolicy policy;
    private final DisposalCallback<C> disposalCallback;
    private final ConnPoolListener<T> connPoolListener;
    private final ConcurrentMap<T, LaxConnPool$PerRoutePool<T, C>> routeToPool;
    private final AtomicBoolean isShutDown;
    private volatile int defaultMaxPerRoute;

    public LaxConnPool(int n2, TimeValue timeValue, PoolReusePolicy poolReusePolicy, DisposalCallback<C> disposalCallback, ConnPoolListener<T> connPoolListener) {
        Args.positive(n2, "Max per route value");
        this.timeToLive = TimeValue.defaultsToNegativeOneMillisecond(timeValue);
        this.policy = poolReusePolicy != null ? poolReusePolicy : PoolReusePolicy.LIFO;
        this.disposalCallback = disposalCallback;
        this.connPoolListener = connPoolListener;
        this.routeToPool = new ConcurrentHashMap<T, LaxConnPool$PerRoutePool<T, C>>();
        this.isShutDown = new AtomicBoolean();
        this.defaultMaxPerRoute = n2;
    }

    public LaxConnPool(int n2, TimeValue timeValue, PoolReusePolicy poolReusePolicy, ConnPoolListener<T> connPoolListener) {
        this(n2, timeValue, poolReusePolicy, null, connPoolListener);
    }

    public LaxConnPool(int n2) {
        this(n2, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, null, null);
    }

    public boolean isShutdown() {
        return this.isShutDown.get();
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.isShutDown.compareAndSet(false, true)) {
            for (LaxConnPool$PerRoutePool laxConnPool$PerRoutePool : this.routeToPool.values()) {
                laxConnPool$PerRoutePool.shutdown(closeMode);
            }
            this.routeToPool.clear();
        }
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    private LaxConnPool$PerRoutePool<T, C> getPool(T t2) {
        LaxConnPool$PerRoutePool<T, C> laxConnPool$PerRoutePool = (LaxConnPool$PerRoutePool<T, C>)this.routeToPool.get(t2);
        if (laxConnPool$PerRoutePool == null) {
            LaxConnPool laxConnPool = this;
            LaxConnPool$PerRoutePool<T, C> laxConnPool$PerRoutePool2 = new LaxConnPool$PerRoutePool<T, C>(t2, this.defaultMaxPerRoute, this.timeToLive, this.policy, laxConnPool, laxConnPool.disposalCallback, this.connPoolListener);
            laxConnPool$PerRoutePool = this.routeToPool.putIfAbsent(t2, laxConnPool$PerRoutePool2);
            if (laxConnPool$PerRoutePool == null) {
                laxConnPool$PerRoutePool = laxConnPool$PerRoutePool2;
            }
        }
        return laxConnPool$PerRoutePool;
    }

    @Override
    public Future<PoolEntry<T, C>> lease(T object, Object object2, Timeout timeout, FutureCallback<PoolEntry<T, C>> futureCallback) {
        Args.notNull(object, "Route");
        Asserts.check(!this.isShutDown.get(), "Connection pool shut down");
        object = this.getPool(object);
        return ((LaxConnPool$PerRoutePool)object).lease(object2, timeout, futureCallback);
    }

    public Future<PoolEntry<T, C>> lease(T t2, Object object) {
        return this.lease(t2, object, Timeout.DISABLED, null);
    }

    @Override
    public void release(PoolEntry<T, C> poolEntry, boolean bl2) {
        if (poolEntry == null) {
            return;
        }
        if (this.isShutDown.get()) {
            return;
        }
        LaxConnPool$PerRoutePool<T, C> laxConnPool$PerRoutePool = this.getPool(poolEntry.getRoute());
        laxConnPool$PerRoutePool.release(poolEntry, bl2);
    }

    public void validatePendingRequests() {
        for (LaxConnPool$PerRoutePool laxConnPool$PerRoutePool : this.routeToPool.values()) {
            laxConnPool$PerRoutePool.validatePendingRequests();
        }
    }

    @Override
    public void setMaxTotal(int n2) {
    }

    @Override
    public int getMaxTotal() {
        return 0;
    }

    @Override
    public void setDefaultMaxPerRoute(int n2) {
        Args.positive(n2, "Max value");
        this.defaultMaxPerRoute = n2;
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    @Override
    public void setMaxPerRoute(T object, int n2) {
        Args.notNull(object, "Route");
        object = this.getPool(object);
        ((LaxConnPool$PerRoutePool)object).setMax(n2 >= 0 ? n2 : this.defaultMaxPerRoute);
    }

    @Override
    public int getMaxPerRoute(T object) {
        Args.notNull(object, "Route");
        object = this.getPool(object);
        return ((LaxConnPool$PerRoutePool)object).getMax();
    }

    @Override
    public PoolStats getTotalStats() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (LaxConnPool$PerRoutePool laxConnPool$PerRoutePool : this.routeToPool.values()) {
            n2 += laxConnPool$PerRoutePool.getLeasedCount();
            n3 += laxConnPool$PerRoutePool.getPendingCount();
            n4 += laxConnPool$PerRoutePool.getAvailableCount();
            n5 += laxConnPool$PerRoutePool.getMax();
        }
        return new PoolStats(n2, n3, n4, n5);
    }

    @Override
    public PoolStats getStats(T object) {
        Args.notNull(object, "Route");
        object = this.getPool(object);
        return new PoolStats(((LaxConnPool$PerRoutePool)object).getLeasedCount(), ((LaxConnPool$PerRoutePool)object).getPendingCount(), ((LaxConnPool$PerRoutePool)object).getAvailableCount(), ((LaxConnPool$PerRoutePool)object).getMax());
    }

    @Override
    public Set<T> getRoutes() {
        return new HashSet(this.routeToPool.keySet());
    }

    public void enumAvailable(Callback<PoolEntry<T, C>> callback) {
        for (LaxConnPool$PerRoutePool laxConnPool$PerRoutePool : this.routeToPool.values()) {
            laxConnPool$PerRoutePool.enumAvailable(callback);
        }
    }

    public void enumLeased(Callback<PoolEntry<T, C>> callback) {
        for (LaxConnPool$PerRoutePool laxConnPool$PerRoutePool : this.routeToPool.values()) {
            laxConnPool$PerRoutePool.enumLeased(callback);
        }
    }

    @Override
    public void closeIdle(TimeValue timeValue) {
        long l2 = System.currentTimeMillis() - (TimeValue.isPositive(timeValue) ? timeValue.toMilliseconds() : 0L);
        this.enumAvailable(poolEntry -> {
            if (poolEntry.getUpdated() <= l2) {
                poolEntry.discardConnection(CloseMode.GRACEFUL);
            }
        });
    }

    @Override
    public void closeExpired() {
        long l2 = System.currentTimeMillis();
        this.enumAvailable(poolEntry -> {
            if (poolEntry.getExpiryDeadline().isBefore(l2)) {
                poolEntry.discardConnection(CloseMode.GRACEFUL);
            }
        });
    }

    public String toString() {
        PoolStats poolStats = this.getTotalStats();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[leased: ");
        stringBuilder.append(poolStats.getLeased());
        stringBuilder.append("][available: ");
        stringBuilder.append(poolStats.getAvailable());
        stringBuilder.append("][pending: ");
        stringBuilder.append(poolStats.getPending());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

