/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.DisposalCallback;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.TimeValue;

public final class PoolEntry<T, C extends ModalCloseable> {
    private final T route;
    private final TimeValue timeToLive;
    private final AtomicReference<C> connRef;
    private final DisposalCallback<C> disposalCallback;
    private final Supplier<Long> currentTimeSupplier;
    private volatile Object state;
    private volatile long created;
    private volatile long updated;
    private volatile Deadline expiryDeadline = Deadline.MIN_VALUE;
    private volatile Deadline validityDeadline = Deadline.MIN_VALUE;

    PoolEntry(T t2, TimeValue timeValue, DisposalCallback<C> disposalCallback, Supplier<Long> supplier) {
        this.route = Args.notNull(t2, "Route");
        this.timeToLive = TimeValue.defaultsToNegativeOneMillisecond(timeValue);
        this.connRef = new AtomicReference();
        this.disposalCallback = disposalCallback;
        this.currentTimeSupplier = supplier;
    }

    PoolEntry(T t2, TimeValue timeValue, Supplier<Long> supplier) {
        this(t2, timeValue, null, supplier);
    }

    public PoolEntry(T t2, TimeValue timeValue, DisposalCallback<C> disposalCallback) {
        this(t2, timeValue, disposalCallback, null);
    }

    public PoolEntry(T t2, TimeValue timeValue) {
        this(t2, timeValue, null, null);
    }

    public PoolEntry(T t2) {
        this(t2, null);
    }

    final long getCurrentTime() {
        if (this.currentTimeSupplier != null) {
            return this.currentTimeSupplier.get();
        }
        return System.currentTimeMillis();
    }

    public final T getRoute() {
        return this.route;
    }

    public final C getConnection() {
        return (C)((ModalCloseable)this.connRef.get());
    }

    public final Deadline getValidityDeadline() {
        return this.validityDeadline;
    }

    public final Object getState() {
        return this.state;
    }

    public final long getCreated() {
        return this.created;
    }

    public final long getUpdated() {
        return this.updated;
    }

    public final Deadline getExpiryDeadline() {
        return this.expiryDeadline;
    }

    public final boolean hasConnection() {
        return this.connRef.get() != null;
    }

    public final void assignConnection(C c2) {
        Args.notNull(c2, "connection");
        if (this.connRef.compareAndSet(null, c2)) {
            this.updated = this.created = this.getCurrentTime();
            this.expiryDeadline = this.validityDeadline = Deadline.calculate(this.created, this.timeToLive);
            this.state = null;
            return;
        }
        throw new IllegalStateException("Connection already assigned");
    }

    public final void discardConnection(CloseMode closeMode) {
        ModalCloseable modalCloseable = this.connRef.getAndSet(null);
        if (modalCloseable != null) {
            this.state = null;
            this.created = 0L;
            this.updated = 0L;
            this.expiryDeadline = Deadline.MIN_VALUE;
            this.validityDeadline = Deadline.MIN_VALUE;
            if (this.disposalCallback != null) {
                this.disposalCallback.execute(modalCloseable, closeMode);
                return;
            }
            modalCloseable.close(closeMode);
        }
    }

    public final void updateExpiry(TimeValue object) {
        Args.notNull(object, "Expiry time");
        long l2 = this.getCurrentTime();
        object = Deadline.calculate(l2, (TimeValue)object);
        this.expiryDeadline = ((Deadline)object).min(this.validityDeadline);
        this.updated = l2;
    }

    public final void updateState(Object object) {
        this.state = object;
        this.updated = this.getCurrentTime();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[route:");
        stringBuilder.append(this.route);
        stringBuilder.append("][state:");
        stringBuilder.append(this.state);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

