/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.Timeout;

class StrictConnPool$LeaseRequest<T, C extends ModalCloseable> {
    private final T route;
    private final Object state;
    private final Deadline deadline;
    private final BasicFuture<PoolEntry<T, C>> future;
    private final AtomicBoolean completed;
    private volatile PoolEntry<T, C> result;
    private volatile Exception ex;

    public StrictConnPool$LeaseRequest(T t2, Object object, Timeout timeout, BasicFuture<PoolEntry<T, C>> basicFuture) {
        this.route = t2;
        this.state = object;
        this.deadline = Deadline.calculate(timeout);
        this.future = basicFuture;
        this.completed = new AtomicBoolean();
    }

    public T getRoute() {
        return this.route;
    }

    public Object getState() {
        return this.state;
    }

    public Deadline getDeadline() {
        return this.deadline;
    }

    public boolean isDone() {
        return this.ex != null || this.result != null;
    }

    public void failed(Exception exception) {
        if (this.completed.compareAndSet(false, true)) {
            this.ex = exception;
        }
    }

    public void completed(PoolEntry<T, C> poolEntry) {
        if (this.completed.compareAndSet(false, true)) {
            this.result = poolEntry;
        }
    }

    public BasicFuture<PoolEntry<T, C>> getFuture() {
        return this.future;
    }

    public PoolEntry<T, C> getResult() {
        return this.result;
    }

    public Exception getException() {
        return this.ex;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.route);
        stringBuilder.append("][");
        stringBuilder.append(this.state);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

