/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.DisposalCallback;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;

class StrictConnPool$PerRoutePool<T, C extends ModalCloseable> {
    private final T route;
    private final Set<PoolEntry<T, C>> leased;
    private final LinkedList<PoolEntry<T, C>> available;
    private final DisposalCallback<C> disposalCallback;

    StrictConnPool$PerRoutePool(T t2, DisposalCallback<C> disposalCallback) {
        this.route = t2;
        this.disposalCallback = disposalCallback;
        this.leased = new HashSet<PoolEntry<T, C>>();
        this.available = new LinkedList();
    }

    public final T getRoute() {
        return this.route;
    }

    public int getLeasedCount() {
        return this.leased.size();
    }

    public int getAvailableCount() {
        return this.available.size();
    }

    public int getAllocatedCount() {
        return this.available.size() + this.leased.size();
    }

    public PoolEntry<T, C> getFree(Object object) {
        if (!this.available.isEmpty()) {
            PoolEntry poolEntry;
            Iterator iterator;
            if (object != null) {
                iterator = this.available.iterator();
                while (iterator.hasNext()) {
                    poolEntry = (PoolEntry)iterator.next();
                    if (!object.equals(poolEntry.getState())) continue;
                    iterator.remove();
                    this.leased.add(poolEntry);
                    return poolEntry;
                }
            }
            iterator = this.available.iterator();
            while (iterator.hasNext()) {
                poolEntry = (PoolEntry)iterator.next();
                if (poolEntry.getState() != null) continue;
                iterator.remove();
                this.leased.add(poolEntry);
                return poolEntry;
            }
        }
        return null;
    }

    public PoolEntry<T, C> getLastUsed() {
        return this.available.peekLast();
    }

    public boolean remove(PoolEntry<T, C> poolEntry) {
        return this.available.remove(poolEntry) || this.leased.remove(poolEntry);
    }

    public void free(PoolEntry<T, C> poolEntry, boolean bl2) {
        boolean bl3 = this.leased.remove(poolEntry);
        Asserts.check(bl3, "Entry %s has not been leased from this pool", poolEntry);
        if (bl2) {
            this.available.addFirst(poolEntry);
        }
    }

    public PoolEntry<T, C> createEntry(TimeValue object) {
        object = new PoolEntry<T, C>(this.route, (TimeValue)object, this.disposalCallback);
        this.leased.add((PoolEntry<T, C>)object);
        return object;
    }

    public void shutdown(CloseMode closeMode) {
        Object object;
        while ((object = this.available.poll()) != null) {
            ((PoolEntry)object).discardConnection(closeMode);
        }
        for (PoolEntry poolEntry : this.leased) {
            poolEntry.discardConnection(closeMode);
        }
        this.leased.clear();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[route: ");
        stringBuilder.append(this.route);
        stringBuilder.append("][leased: ");
        stringBuilder.append(this.leased.size());
        stringBuilder.append("][available: ");
        stringBuilder.append(this.available.size());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

